(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w245, h249,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
Quantum Mechanical Interference in a Simple Quantum Computation
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams 
:[font = input; initialization; preserveAspect]
*)
Off[General::spell1]
(*
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; locked; preserveAspect; startGroup]
How to use this Notebook
:[font = text; inactive; locked; preserveAspect]
This Notebook contains code for analyzing the effects of quantum mechanical interference on the outcome of a quantum computation (see "Explorations in Quantum Computing", Chapter 3).  The computation in question is the generation of a random bit using first a classical method and then a quantum method. The code allows you to calculate, and compare, the overall probability of obtaining the answer "0" using each method. In general, you will find that the quantum probability can be the same as, greater than or less than the classical probability of returning the answer "0".

You are encouraged to work through the Notebook, executing commands labelled as "Try me!" as you go.  To execute a such a command, position your cursor over the cell containing the command, click the mouse to select the cell and type the SHIFT and RETURN keys simultaneously.

The following functions are available:
:[font = input; locked; preserveAspect]
Pclassical		(* probability of classical method returning a 0   *)
Pquantum		(* probability of quantum method returning a 0     *)
ComparisonPlot  (* plot of Pclassical and Pquantum versus phi      *)
PhaseDiagram	(* plot of co-variation of Pclassical and Pquantum *)
:[font = text; inactive; locked; preserveAspect; endGroup]
To learn how to use any of these commands enter ?Pclassical, ?Pquantum etc.
:[font = section; inactive; locked; preserveAspect; startGroup]
How to Generate a Bit?
:[font = text; inactive; locked; preserveAspect]
We begin by introducing the computation that we want to analyze. Let us suppose that we want our computer to pick a random bit i.e. to pick either a 0 or a 1. This is equivalent of course to all sorts of other binary selection problems.  We will do this as a two stage process: first we will pick the method (Method A or Method B) that will be used to generate the bit and then we will run the method we selected and record the result.  Let us say that we pick Method A with probability p and we pick Method B with probability (1-p).  Then, if we run Method A, let us assume that a "0" bit is returned with probability p0A, and a "1" is returned with probability p1A = 1-p0A. Likewise, if we run Method B,  let us assume that a "0" bit is returned with probability p0B, and a "1" is returned with probability p1B = 1-p0B.

What is the classical probability of this scheme returning a "0"? The answer is simply
:[font = input; locked; preserveAspect; plain]
p p0A + (1 - p) p0B
:[font = text; inactive; locked; preserveAspect]
because we first pick Method A with probability p and then obtain a "0" with probability p0A else we pick Method B with probability (1-p) and then obtain a "0" with probability p0B.

Now quantum mechanically, things are a little different. To pick the method to be used we can imagine creating the state |psi> defined as
:[font = input; locked; preserveAspect; plain]
|psi> = Sqrt[p] ket[0] + Sqrt[1-p] ket[1]
:[font = text; inactive; locked; preserveAspect]
If we measure |psi> in the 0/1 basis, we obtain a "0" with probability p and a "1" with probability 1-p because, quantum mechanically, the probabilities are given by the square of the absolute values of the (normalized) amplitudes).  We can use a measurement of the state |psi> to mimic the selection of Method A or Method B as follows:   if we measure |psi> and obtain a "0" we will say we picked Method A and if we measure |psi> and obtain "1" we will say we picked Method B. Notice, that so far we have simply made a quantum analog of the first part of the classical algorithm and the qunatum and classical probabilities of picking Method A or Method B agree.

As probabilities are always real numbers between 0 and 1,  we can also introduce a new variable, phi, which you can think of as angle, defined so that p = Cos[phi]^2. Thus for any value of the probability p, there are corresponding values of phi, all of which give the same value of Cos[phi]^2.  Using phi, the state |psi> can be rewritten as:
:[font = input; locked; preserveAspect; plain]
|psi> = Cos[phi] ket[0] + Sin[phi] ket[1].
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
Here is a plot showing how p and phi are related.
:[font = input; preserveAspect; startGroup]
Plot[ProbabilityToAngle[p], {p, 0, 1},
     Frame->True,
     GridLines->Automatic,
     FrameLabel->{"p", "phi"}];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.374717 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(p)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.25)] -0.0125 .10839 1 0 0 Minner Mrotsboxa
[(0.5)] -0.0125 .20207 1 0 0 Minner Mrotsboxa
[(0.75)] -0.0125 .29575 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .38943 1 0 0 Minner Mrotsboxa
[(1.25)] -0.0125 .48311 1 0 0 Minner Mrotsboxa
[(1.5)] -0.0125 .57679 1 0 0 Minner Mrotsboxa
[(phi)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.21429 0 m
.21429 .61803 L
s
P
p
0 0 .5 r
.001 w
.40476 0 m
.40476 .61803 L
s
P
p
0 0 .5 r
.001 w
.59524 0 m
.59524 .61803 L
s
P
p
0 0 .5 r
.001 w
.78571 0 m
.78571 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .10839 m
1 .10839 L
s
P
p
0 0 .5 r
.001 w
0 .20207 m
1 .20207 L
s
P
p
0 0 .5 r
.001 w
0 .29575 m
1 .29575 L
s
P
p
0 0 .5 r
.001 w
0 .38943 m
1 .38943 L
s
P
p
0 0 .5 r
.001 w
0 .48311 m
1 .48311 L
s
P
p
0 0 .5 r
.001 w
0 .57679 m
1 .57679 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(p)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .10839 m
.00625 .10839 L
s
P
[(0.25)] -0.0125 .10839 1 0 0 Minner Mrotshowa
p
.002 w
0 .20207 m
.00625 .20207 L
s
P
[(0.5)] -0.0125 .20207 1 0 0 Minner Mrotshowa
p
.002 w
0 .29575 m
.00625 .29575 L
s
P
[(0.75)] -0.0125 .29575 1 0 0 Minner Mrotshowa
p
.002 w
0 .38943 m
.00625 .38943 L
s
P
[(1)] -0.0125 .38943 1 0 0 Minner Mrotshowa
p
.002 w
0 .48311 m
.00625 .48311 L
s
P
[(1.25)] -0.0125 .48311 1 0 0 Minner Mrotshowa
p
.002 w
0 .57679 m
.00625 .57679 L
s
P
[(1.5)] -0.0125 .57679 1 0 0 Minner Mrotshowa
p
.001 w
0 .03345 m
.00375 .03345 L
s
P
p
.001 w
0 .05219 m
.00375 .05219 L
s
P
p
.001 w
0 .07092 m
.00375 .07092 L
s
P
p
.001 w
0 .08966 m
.00375 .08966 L
s
P
p
.001 w
0 .12713 m
.00375 .12713 L
s
P
p
.001 w
0 .14587 m
.00375 .14587 L
s
P
p
.001 w
0 .1646 m
.00375 .1646 L
s
P
p
.001 w
0 .18334 m
.00375 .18334 L
s
P
p
.001 w
0 .22081 m
.00375 .22081 L
s
P
p
.001 w
0 .23955 m
.00375 .23955 L
s
P
p
.001 w
0 .25828 m
.00375 .25828 L
s
P
p
.001 w
0 .27702 m
.00375 .27702 L
s
P
p
.001 w
0 .31449 m
.00375 .31449 L
s
P
p
.001 w
0 .33322 m
.00375 .33322 L
s
P
p
.001 w
0 .35196 m
.00375 .35196 L
s
P
p
.001 w
0 .3707 m
.00375 .3707 L
s
P
p
.001 w
0 .40817 m
.00375 .40817 L
s
P
p
.001 w
0 .4269 m
.00375 .4269 L
s
P
p
.001 w
0 .44564 m
.00375 .44564 L
s
P
p
.001 w
0 .46438 m
.00375 .46438 L
s
P
p
.001 w
0 .50185 m
.00375 .50185 L
s
P
p
.001 w
0 .52058 m
.00375 .52058 L
s
P
p
.001 w
0 .53932 m
.00375 .53932 L
s
P
p
.001 w
0 .55805 m
.00375 .55805 L
s
P
p
.001 w
0 .59553 m
.00375 .59553 L
s
P
p
.001 w
0 .61426 m
.00375 .61426 L
s
P
[(phi)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.21429 .61178 m
.21429 .61803 L
s
P
p
.002 w
.40476 .61178 m
.40476 .61803 L
s
P
p
.002 w
.59524 .61178 m
.59524 .61803 L
s
P
p
.002 w
.78571 .61178 m
.78571 .61803 L
s
P
p
.002 w
.97619 .61178 m
.97619 .61803 L
s
P
p
.001 w
.0619 .61428 m
.0619 .61803 L
s
P
p
.001 w
.1 .61428 m
.1 .61803 L
s
P
p
.001 w
.1381 .61428 m
.1381 .61803 L
s
P
p
.001 w
.17619 .61428 m
.17619 .61803 L
s
P
p
.001 w
.25238 .61428 m
.25238 .61803 L
s
P
p
.001 w
.29048 .61428 m
.29048 .61803 L
s
P
p
.001 w
.32857 .61428 m
.32857 .61803 L
s
P
p
.001 w
.36667 .61428 m
.36667 .61803 L
s
P
p
.001 w
.44286 .61428 m
.44286 .61803 L
s
P
p
.001 w
.48095 .61428 m
.48095 .61803 L
s
P
p
.001 w
.51905 .61428 m
.51905 .61803 L
s
P
p
.001 w
.55714 .61428 m
.55714 .61803 L
s
P
p
.001 w
.63333 .61428 m
.63333 .61803 L
s
P
p
.001 w
.67143 .61428 m
.67143 .61803 L
s
P
p
.001 w
.70952 .61428 m
.70952 .61803 L
s
P
p
.001 w
.74762 .61428 m
.74762 .61803 L
s
P
p
.001 w
.82381 .61428 m
.82381 .61803 L
s
P
p
.001 w
.8619 .61428 m
.8619 .61803 L
s
P
p
.001 w
.9 .61428 m
.9 .61803 L
s
P
p
.001 w
.9381 .61428 m
.9381 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .10839 m
1 .10839 L
s
P
p
.002 w
.99375 .20207 m
1 .20207 L
s
P
p
.002 w
.99375 .29575 m
1 .29575 L
s
P
p
.002 w
.99375 .38943 m
1 .38943 L
s
P
p
.002 w
.99375 .48311 m
1 .48311 L
s
P
p
.002 w
.99375 .57679 m
1 .57679 L
s
P
p
.001 w
.99625 .03345 m
1 .03345 L
s
P
p
.001 w
.99625 .05219 m
1 .05219 L
s
P
p
.001 w
.99625 .07092 m
1 .07092 L
s
P
p
.001 w
.99625 .08966 m
1 .08966 L
s
P
p
.001 w
.99625 .12713 m
1 .12713 L
s
P
p
.001 w
.99625 .14587 m
1 .14587 L
s
P
p
.001 w
.99625 .1646 m
1 .1646 L
s
P
p
.001 w
.99625 .18334 m
1 .18334 L
s
P
p
.001 w
.99625 .22081 m
1 .22081 L
s
P
p
.001 w
.99625 .23955 m
1 .23955 L
s
P
p
.001 w
.99625 .25828 m
1 .25828 L
s
P
p
.001 w
.99625 .27702 m
1 .27702 L
s
P
p
.001 w
.99625 .31449 m
1 .31449 L
s
P
p
.001 w
.99625 .33322 m
1 .33322 L
s
P
p
.001 w
.99625 .35196 m
1 .35196 L
s
P
p
.001 w
.99625 .3707 m
1 .3707 L
s
P
p
.001 w
.99625 .40817 m
1 .40817 L
s
P
p
.001 w
.99625 .4269 m
1 .4269 L
s
P
p
.001 w
.99625 .44564 m
1 .44564 L
s
P
p
.001 w
.99625 .46438 m
1 .46438 L
s
P
p
.001 w
.99625 .50185 m
1 .50185 L
s
P
p
.001 w
.99625 .52058 m
1 .52058 L
s
P
p
.001 w
.99625 .53932 m
1 .53932 L
s
P
p
.001 w
.99625 .55805 m
1 .55805 L
s
P
p
.001 w
.99625 .59553 m
1 .59553 L
s
P
p
.001 w
.99625 .61426 m
1 .61426 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .60332 m
.02505 .58979 L
.02629 .58419 L
.02877 .57625 L
.03373 .56501 L
.04365 .54904 L
.06349 .52629 L
.10317 .49359 L
.14286 .46791 L
.18254 .44574 L
.22222 .42571 L
.2619 .40712 L
.30159 .38954 L
.34127 .37269 L
.38095 .35636 L
.42063 .34039 L
.46032 .32465 L
.5 .30902 L
.53968 .29339 L
.57937 .27764 L
.61905 .26168 L
.65873 .24535 L
.69841 .22849 L
.7381 .21092 L
.77778 .19233 L
.81746 .1723 L
.85714 .15013 L
.89683 .12445 L
.93651 .09175 L
.94643 .08131 L
.95635 .06899 L
.96131 .06168 L
.96627 .05303 L
.96875 .04788 L
.97123 .04178 L
.97371 .03385 L
.97495 .02824 L
.97619 .01472 L
s
P
P
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]

:[font = text; inactive; preserveAspect]
Next we create states |A> and |B> that can mimic the second stage of the bit generation algorithm. Suppose we define:
:[font = input; preserveAspect; plain]
|A> = Sqrt[p0A] ket[0] + Sqrt[1-p0A] ket[1]
    = w0A ket[0] + w1A ket[1]
:[font = input; preserveAspect; plain]
|B> = -Sqrt[p0B] ket[0] + Sqrt[1-p0B] ket[1]
    = w0B ket[0] + w1B ket[1]
:[font = text; inactive; preserveAspect]
Again, if we measure state |A> we obtain a "0" with probability p0A, if we measure |B> we obtain a 0 with probability p0B. The minus sign introduced in |B> has no ill-effect on the probability because we square the absolute value of the amplitude to get the probability, plus or minus Sqrt[p0B] is equally acceptable.  So if you look at |B> in isolation, it too gives the same probability of returning a "0" as does the classical Method B. However,  quantum mechanically, you cannot really treat |A> and |B> in isolation. A quantum computer pursues BOTH computational paths simultaneously and THEN determines the final outcome from the interference between ALL these paths.  Thus, in the quantum mechanical scheme for picking a bit the minus sign will turn out to be important when we consider the interaction between the state |B> and the state |A>, because you always ADD amplitudes before calculating probabilities.

To combine both parts of the quantum  selection algorithm, the selection of Method A or Method B and the ensuing measurement of states |A> or |B>, we do the following. First add the amplitudes of all pathways leading to the "0" outcome and then compute probabilities, from the square modulus of the net amplitude of the "0" outcome.  Thus to obtain a "0", Method A is selected with amplitude Sqrt[p]=Cos[phi], and Method B is selected with amplitude Sqrt[1-p] = Sin[phi]. So overall, the relative contribution of the two methods to the "0" answer is:
:[font = input; preserveAspect; plain]
Abs[Cos[phi] w0A + Sin[phi] w0B]^2
:[font = text; inactive; preserveAspect]
However we are not quite done because, in addition, we need to renormalize the state because we know we can only get a "0" or a "1" as the final answer. The true (renormalized) probability of the quantum method yielding a "0" is then:
:[font = input; preserveAspect; plain]
Abs[(Cos[phi] w0A + Sin[phi] w0B)/norm]^2
:[font = text; inactive; preserveAspect]
where norm is given by:
:[font = input; preserveAspect; plain]
norm = Sqrt[Abs[Cos[phi] w0A + Sin[phi] w0B]^2 + 
            Abs[Cos[phi] w1A + Sin[phi] w1B]^2]
:[font = text; inactive; preserveAspect]
Thus we arrive at the formulae for the classical and quantum probabilities of obtaining the "0" outcome. The classical answer, Pclassical = p p0A + (1 - o) p0B,  can be re-written using our "phi" variable defined via p = Cos[phi]^2. Thus we have,
:[font = input; preserveAspect; cellOutline]
Pclassical = Cos[phi]^2 p0A + Sin[phi]^2 p0B

Pquantum   = Abs[(Cos[phi] w0A + Sin[phi] w0B)/norm]^2
:[font = text; inactive; preserveAspect]
where
:[font = input; preserveAspect; plain; endGroup; endGroup]
norm = Sqrt[Abs[Cos[phi] w0A + Sin[phi] w0B]^2 + 
            Abs[Cos[phi] w1A + Sin[phi] w1B]^2]

w0A  =  Sqrt[p0A]
w0B  = -Sqrt[p0B]
w1A  =  Sqrt[1-p0A]
w1B  =  Sqrt[1-p0B].
:[font = section; inactive; preserveAspect; startGroup]
Quantum Mechanical Interference Between Alternative Computational Pathways
:[font = text; inactive; preserveAspect]
The state of the memory register of a quantum computer can be thought of as recording the results of several parallel computations at once.  However, unlike a conventional parallel computer, in a quantum computer the parallel computations interfere with one another.  As a result the final answer that a quantum computer arrives at, recorded in the final state of the quantum memory register,  can be different from what one would expect classically. 

Here is a simple example that illustrates the difference between a quantum computer and a classical computer.  
:[font = subsection; inactive; preserveAspect; startGroup]
Classical Probability, Pclassical
:[font = text; inactive; preserveAspect]
Classically, our computer picks method A or B to generate the bit. For example, each method may consist of tossing a different coin. 
:[font = input; preserveAspect; startGroup]
?Pclassical
:[font = print; inactive; preserveAspect; endGroup]
Pclassical[phi, p0A, p0B] gives the probability of a classical computer picking a 0
   using either Method A or Method B.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = input; preserveAspect; startGroup]
Pclassical[phi, 3/4, 1/4]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
1/2 + Cos[2*phi]/4
;[o]
1   Cos[2 phi]
- + ----------
2       4
:[font = subsection; inactive; preserveAspect; startGroup]
Quantum probability, Pquantum
:[font = input; preserveAspect; startGroup]
?Pquantum
:[font = print; inactive; preserveAspect; endGroup]
Pquantum[phi, p0A, p0B] gives the probability of a quantum computer picking a 0
   using both Method A or Method B in quantum parallel. Note that both computational
   pathways are pursued. The final answer is arrived as as the outcome from the
   interference between these computational pathways.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
Using the same values for p0A and p0B as above we see that the analytic form for the quantum probability of obtaining a "0" outcome can be the greater than, less than or equal to the classical probability for obtaining a "0" outcome.
:[font = input; preserveAspect; startGroup]
Pquantum[phi, 3/4, 1/4]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
1/2 + Cos[2*phi]/4 - (3^(1/2)*Sin[2*phi])/4
;[o]
1   Cos[2 phi]   Sqrt[3] Sin[2 phi]
- + ---------- - ------------------
2       4                4
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
We can compare the quantum (light) and classical (dark) probabilities, for a given value of phi, directly using the ComparisonPlot function:
:[font = input; preserveAspect; startGroup]
?ComparisonPlot
:[font = print; inactive; preserveAspect; endGroup]
ComparisonPlot[p0A, p0B] creates a plot that allows you to compare Pclassical (dark)
   and Pquantum (light) as the angle phi changes from 0 to 2 Pi.
:[font = input; preserveAspect; startGroup]
ComparisonPlot[3/4, 1/4];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147151 0.588604 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13244 m
1 .13244 L
s
P
p
0 0 .5 r
.001 w
0 .25016 m
1 .25016 L
s
P
p
0 0 .5 r
.001 w
0 .36788 m
1 .36788 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .13244 m
.00625 .13244 L
s
P
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotshowa
p
.002 w
0 .25016 m
.00625 .25016 L
s
P
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotshowa
p
.002 w
0 .36788 m
.00625 .36788 L
s
P
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .0618 m
.00375 .0618 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .10889 m
.00375 .10889 L
s
P
p
.001 w
0 .15598 m
.00375 .15598 L
s
P
p
.001 w
0 .17952 m
.00375 .17952 L
s
P
p
.001 w
0 .20307 m
.00375 .20307 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29724 m
.00375 .29724 L
s
P
p
.001 w
0 .32079 m
.00375 .32079 L
s
P
p
.001 w
0 .34433 m
.00375 .34433 L
s
P
p
.001 w
0 .39142 m
.00375 .39142 L
s
P
p
.001 w
0 .41497 m
.00375 .41497 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46205 m
.00375 .46205 L
s
P
p
.001 w
0 .50914 m
.00375 .50914 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .13244 m
1 .13244 L
s
P
p
.002 w
.99375 .25016 m
1 .25016 L
s
P
p
.002 w
.99375 .36788 m
1 .36788 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .0618 m
1 .0618 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .10889 m
1 .10889 L
s
P
p
.001 w
.99625 .15598 m
1 .15598 L
s
P
p
.001 w
.99625 .17952 m
1 .17952 L
s
P
p
.001 w
.99625 .20307 m
1 .20307 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29724 m
1 .29724 L
s
P
p
.001 w
.99625 .32079 m
1 .32079 L
s
P
p
.001 w
.99625 .34433 m
1 .34433 L
s
P
p
.001 w
.99625 .39142 m
1 .39142 L
s
P
p
.001 w
.99625 .41497 m
1 .41497 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46205 m
1 .46205 L
s
P
p
.001 w
.99625 .50914 m
1 .50914 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .45617 m
.06349 .30902 L
.10317 .16187 L
.12302 .10091 L
.13294 .07553 L
.14286 .05414 L
.15278 .03712 L
.15774 .03033 L
.1627 .02474 L
.16766 .02037 L
.17014 .01865 L
.17262 .01723 L
.1751 .01613 L
.17634 .0157 L
.17758 .01535 L
.17882 .01507 L
.18006 .01487 L
.1813 .01475 L
.18254 .01472 L
.18378 .01475 L
.18502 .01487 L
.18626 .01507 L
.1875 .01535 L
.18998 .01613 L
.19246 .01723 L
.19494 .01865 L
.19742 .02037 L
.20238 .02474 L
.2123 .03712 L
.22222 .05414 L
.24206 .10091 L
.2619 .16187 L
.30159 .30902 L
.34127 .45617 L
.36111 .51712 L
.37103 .5425 L
.38095 .56389 L
.39087 .58092 L
.40079 .59329 L
.40575 .59766 L
.40823 .59939 L
.41071 .6008 L
.41319 .6019 L
.41443 .60233 L
.41567 .60269 L
.41691 .60296 L
.41815 .60316 L
.41939 .60328 L
.42063 .60332 L
.42188 .60328 L
Mistroke
.42312 .60316 L
.42436 .60296 L
.4256 .60269 L
.42684 .60233 L
.42808 .6019 L
.43056 .6008 L
.43304 .59939 L
.43552 .59766 L
.44048 .59329 L
.4504 .58092 L
.46032 .56389 L
.48016 .51712 L
.5 .45617 L
.53968 .30902 L
.57937 .16187 L
.59921 .10091 L
.60913 .07553 L
.61905 .05414 L
.62897 .03712 L
.63393 .03033 L
.63889 .02474 L
.64385 .02037 L
.64633 .01865 L
.64881 .01723 L
.65129 .01613 L
.65253 .0157 L
.65377 .01535 L
.65501 .01507 L
.65625 .01487 L
.65749 .01475 L
.65873 .01472 L
.65997 .01475 L
.66121 .01487 L
.66245 .01507 L
.66369 .01535 L
.66617 .01613 L
.66865 .01723 L
.67113 .01865 L
.67361 .02037 L
.67857 .02474 L
.68849 .03712 L
.69841 .05414 L
.71825 .10091 L
.7381 .16187 L
.77778 .30902 L
.81746 .45617 L
.8373 .51712 L
.84722 .5425 L
.85714 .56389 L
.86706 .58092 L
Mistroke
.87202 .5877 L
.87698 .59329 L
.88194 .59766 L
.88442 .59939 L
.8869 .6008 L
.88938 .6019 L
.89062 .60233 L
.89187 .60269 L
.89311 .60296 L
.89435 .60316 L
.89559 .60328 L
.89683 .60332 L
.89807 .60328 L
.89931 .60316 L
.90055 .60296 L
.90179 .60269 L
.90427 .6019 L
.90675 .6008 L
.90923 .59939 L
.91171 .59766 L
.91667 .59329 L
.92659 .58092 L
.93651 .56389 L
.95635 .51712 L
.97619 .45617 L
Mfstroke
P
P
p
p
.02 w
.02381 .45617 m
.02505 .45615 L
.02629 .45609 L
.02753 .45599 L
.02877 .45585 L
.03001 .45568 L
.03125 .45546 L
.03373 .45491 L
.03621 .4542 L
.03869 .45334 L
.04365 .45115 L
.05357 .44497 L
.06349 .43645 L
.08333 .41307 L
.10317 .38259 L
.14286 .30902 L
.18254 .23544 L
.20238 .20497 L
.2123 .19227 L
.22222 .18158 L
.23214 .17307 L
.2371 .16968 L
.24206 .16688 L
.24702 .16469 L
.2495 .16383 L
.25198 .16312 L
.25446 .16257 L
.2557 .16236 L
.25694 .16218 L
.25818 .16204 L
.25942 .16194 L
.26066 .16189 L
.2619 .16187 L
.26314 .16189 L
.26438 .16194 L
.26562 .16204 L
.26687 .16218 L
.26935 .16257 L
.27183 .16312 L
.27431 .16383 L
.27679 .16469 L
.28175 .16688 L
.29167 .17307 L
.30159 .18158 L
.32143 .20497 L
.34127 .23544 L
.38095 .30902 L
.42063 .38259 L
.44048 .41307 L
.4504 .42576 L
Mistroke
.46032 .43645 L
.47024 .44497 L
.48016 .45115 L
.48512 .45334 L
.4876 .4542 L
.49008 .45491 L
.49256 .45546 L
.4938 .45568 L
.49504 .45585 L
.49628 .45599 L
.49752 .45609 L
.49876 .45615 L
.5 .45617 L
.50124 .45615 L
.50248 .45609 L
.50372 .45599 L
.50496 .45585 L
.5062 .45568 L
.50744 .45546 L
.50992 .45491 L
.5124 .4542 L
.51488 .45334 L
.51984 .45115 L
.52976 .44497 L
.53968 .43645 L
.55952 .41307 L
.57937 .38259 L
.61905 .30902 L
.65873 .23544 L
.67857 .20497 L
.68849 .19227 L
.69841 .18158 L
.70833 .17307 L
.71329 .16968 L
.71825 .16688 L
.72321 .16469 L
.72569 .16383 L
.72817 .16312 L
.73065 .16257 L
.73189 .16236 L
.73313 .16218 L
.73437 .16204 L
.73562 .16194 L
.73686 .16189 L
.7381 .16187 L
.73934 .16189 L
.74058 .16194 L
.74182 .16204 L
.74306 .16218 L
.74554 .16257 L
Mistroke
.74802 .16312 L
.7505 .16383 L
.75298 .16469 L
.75794 .16688 L
.76786 .17307 L
.77778 .18158 L
.79762 .20497 L
.81746 .23544 L
.85714 .30902 L
.89683 .38259 L
.91667 .41307 L
.93651 .43645 L
.94643 .44497 L
.95139 .44836 L
.95635 .45115 L
.96131 .45334 L
.96379 .4542 L
.96627 .45491 L
.96875 .45546 L
.96999 .45568 L
.97123 .45585 L
.97247 .45599 L
.97371 .45609 L
.97495 .45615 L
.97619 .45617 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
To see how Pclassical and Pquantum co-vary, use PhaseDiagram.
:[font = input; preserveAspect; startGroup]
?PhaseDiagram
:[font = print; inactive; preserveAspect; endGroup]
PhaseDiagram[p0A, p0B] displays corresponding pairs of values for Pclassical and
   Pquantum. The line at 45 degrees indicates where both probabilities are equal. In
   the region above this line Pquantum > Pclassical and in the region below the 45
   degree line Pquantum < Pclassical.
:[font = input; preserveAspect; startGroup]
PhaseDiagram[3/4, 1/4];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 196; pictureHeight = 196; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.7381 .7381 Mdot
.73805 .7298 Mdot
.7379 .72141 Mdot
.73767 .71294 Mdot
.73733 .70438 Mdot
.73691 .69574 Mdot
.73638 .68701 Mdot
.73577 .67822 Mdot
.73505 .66935 Mdot
.73425 .66042 Mdot
.73335 .65142 Mdot
.73236 .64236 Mdot
.73127 .63324 Mdot
.73009 .62407 Mdot
.72882 .61486 Mdot
.72746 .60559 Mdot
.72601 .59628 Mdot
.72447 .58694 Mdot
.72283 .57756 Mdot
.72111 .56815 Mdot
.7193 .55871 Mdot
.7174 .54924 Mdot
.71542 .53976 Mdot
.71335 .53026 Mdot
.71119 .52075 Mdot
.70895 .51124 Mdot
.70662 .50171 Mdot
.70422 .49219 Mdot
.70173 .48267 Mdot
.69916 .47316 Mdot
.69651 .46365 Mdot
.69378 .45417 Mdot
.69098 .4447 Mdot
.68809 .43525 Mdot
.68514 .42583 Mdot
.68211 .41643 Mdot
.679 .40708 Mdot
.67583 .39775 Mdot
.67258 .38847 Mdot
.66927 .37924 Mdot
.66588 .37005 Mdot
.66243 .36091 Mdot
.65892 .35183 Mdot
.65534 .34281 Mdot
.6517 .33386 Mdot
.648 .32496 Mdot
.64424 .31614 Mdot
.64043 .30739 Mdot
.63655 .29872 Mdot
.63262 .29013 Mdot
.62864 .28163 Mdot
.62461 .27321 Mdot
.62053 .26488 Mdot
.6164 .25664 Mdot
.61222 .24851 Mdot
.608 .24047 Mdot
.60373 .23254 Mdot
.59943 .22471 Mdot
.59508 .217 Mdot
.5907 .2094 Mdot
.58628 .20191 Mdot
.58182 .19454 Mdot
.57733 .1873 Mdot
.57281 .18018 Mdot
.56827 .17319 Mdot
.56369 .16633 Mdot
.55909 .1596 Mdot
.55446 .15301 Mdot
.54982 .14655 Mdot
.54515 .14024 Mdot
.54047 .13408 Mdot
.53577 .12805 Mdot
.53105 .12218 Mdot
.52633 .11646 Mdot
.52159 .11089 Mdot
.51684 .10548 Mdot
.51209 .10023 Mdot
.50733 .09513 Mdot
.50257 .0902 Mdot
.49781 .08543 Mdot
.49305 .08083 Mdot
.48829 .0764 Mdot
.48354 .07213 Mdot
.47879 .06804 Mdot
.47405 .06411 Mdot
.46932 .06037 Mdot
.46461 .0568 Mdot
.45991 .0534 Mdot
.45522 .05019 Mdot
.45055 .04715 Mdot
.4459 .0443 Mdot
.44128 .04162 Mdot
.43668 .03914 Mdot
.4321 .03683 Mdot
.42755 .03471 Mdot
.42303 .03278 Mdot
.41854 .03103 Mdot
.41408 .02947 Mdot
.40965 .0281 Mdot
.40527 .02692 Mdot
.40092 .02593 Mdot
.39661 .02513 Mdot
.39234 .02451 Mdot
.38811 .02409 Mdot
.38393 .02386 Mdot
.3798 .02382 Mdot
.37571 .02397 Mdot
.37168 .0243 Mdot
.36769 .02483 Mdot
.36376 .02555 Mdot
.35988 .02646 Mdot
.35606 .02756 Mdot
.35229 .02885 Mdot
.34859 .03032 Mdot
.34495 .03199 Mdot
.34136 .03384 Mdot
.33784 .03588 Mdot
.33439 .0381 Mdot
.331 .04051 Mdot
.32768 .0431 Mdot
.32443 .04587 Mdot
.32125 .04883 Mdot
.31814 .05197 Mdot
.3151 .05528 Mdot
.31214 .05878 Mdot
.30925 .06245 Mdot
.30644 .06629 Mdot
.30371 .07031 Mdot
.30105 .0745 Mdot
.29847 .07886 Mdot
.29598 .08339 Mdot
.29357 .08809 Mdot
.29123 .09295 Mdot
.28899 .09797 Mdot
.28682 .10315 Mdot
.28474 .1085 Mdot
.28275 .114 Mdot
.28085 .11965 Mdot
.27903 .12546 Mdot
.2773 .13141 Mdot
.27566 .13751 Mdot
.27411 .14376 Mdot
.27265 .15015 Mdot
.27128 .15668 Mdot
.27 .16335 Mdot
.26882 .17015 Mdot
.26773 .17709 Mdot
.26673 .18415 Mdot
.26582 .19134 Mdot
.26501 .19866 Mdot
.26429 .20609 Mdot
.26366 .21364 Mdot
.26313 .22131 Mdot
.2627 .22909 Mdot
.26236 .23697 Mdot
.26211 .24496 Mdot
.26196 .25306 Mdot
.26191 .26125 Mdot
.26195 .26954 Mdot
.26208 .27792 Mdot
.26231 .28638 Mdot
.26264 .29494 Mdot
.26306 .30357 Mdot
.26357 .31229 Mdot
.26418 .32108 Mdot
.26489 .32994 Mdot
.26568 .33887 Mdot
.26658 .34786 Mdot
.26756 .35692 Mdot
.26864 .36603 Mdot
.26981 .37519 Mdot
.27107 .38441 Mdot
.27243 .39367 Mdot
.27387 .40297 Mdot
.27541 .41232 Mdot
.27703 .42169 Mdot
.27875 .4311 Mdot
.28055 .44054 Mdot
.28244 .45 Mdot
.28442 .45948 Mdot
.28649 .46898 Mdot
.28864 .47849 Mdot
.29087 .48801 Mdot
.29319 .49753 Mdot
.29559 .50705 Mdot
.29807 .51657 Mdot
.30063 .52609 Mdot
.30328 .53559 Mdot
.306 .54508 Mdot
.3088 .55455 Mdot
.31167 .564 Mdot
.31463 .57342 Mdot
.31765 .58282 Mdot
.32075 .59218 Mdot
.32392 .6015 Mdot
.32716 .61079 Mdot
.33047 .62003 Mdot
.33385 .62922 Mdot
.33729 .63836 Mdot
.3408 .64744 Mdot
.34437 .65647 Mdot
.34801 .66543 Mdot
.3517 .67433 Mdot
.35546 .68316 Mdot
.35927 .69191 Mdot
.36314 .70059 Mdot
.36706 .70919 Mdot
.37104 .7177 Mdot
.37507 .72613 Mdot
.37914 .73446 Mdot
.38327 .7427 Mdot
.38744 .75085 Mdot
.39166 .75889 Mdot
.39592 .76683 Mdot
.40023 .77467 Mdot
.40457 .78239 Mdot
.40895 .79 Mdot
.41337 .7975 Mdot
.41782 .80488 Mdot
.42231 .81213 Mdot
.42683 .81926 Mdot
.43137 .82626 Mdot
.43594 .83313 Mdot
.44054 .83987 Mdot
.44517 .84647 Mdot
.44981 .85294 Mdot
.45448 .85926 Mdot
.45916 .86544 Mdot
.46386 .87147 Mdot
.46857 .87736 Mdot
.4733 .88309 Mdot
.47803 .88867 Mdot
.48278 .89409 Mdot
.48753 .89936 Mdot
.49229 .90447 Mdot
.49705 .90941 Mdot
.50181 .91419 Mdot
.50657 .91881 Mdot
.51133 .92326 Mdot
.51609 .92754 Mdot
.52083 .93164 Mdot
.52557 .93558 Mdot
.5303 .93934 Mdot
.53502 .94293 Mdot
.53972 .94633 Mdot
.54441 .94956 Mdot
.54908 .95261 Mdot
.55373 .95548 Mdot
.55835 .95817 Mdot
.56296 .96067 Mdot
.56754 .96299 Mdot
.57209 .96513 Mdot
.57661 .96707 Mdot
.58111 .96884 Mdot
.58557 .97041 Mdot
.58999 .97179 Mdot
.59439 .97299 Mdot
.59874 .974 Mdot
.60305 .97482 Mdot
.60732 .97544 Mdot
.61155 .97588 Mdot
.61574 .97613 Mdot
.61987 .97619 Mdot
.62396 .97605 Mdot
.628 .97573 Mdot
.63199 .97522 Mdot
.63593 .97451 Mdot
.63981 .97362 Mdot
.64364 .97253 Mdot
.64741 .97126 Mdot
.65112 .9698 Mdot
.65477 .96815 Mdot
.65835 .96632 Mdot
.66188 .96429 Mdot
.66534 .96208 Mdot
.66873 .95969 Mdot
.67206 .95711 Mdot
.67531 .95435 Mdot
.6785 .95141 Mdot
.68162 .94829 Mdot
.68466 .94499 Mdot
.68763 .94151 Mdot
.69052 .93785 Mdot
.69334 .93402 Mdot
.69608 .93002 Mdot
.69874 .92584 Mdot
.70132 .92149 Mdot
.70383 .91698 Mdot
.70625 .91229 Mdot
.70858 .90745 Mdot
.71084 .90244 Mdot
.71301 .89727 Mdot
.71509 .89193 Mdot
.71709 .88645 Mdot
.719 .88081 Mdot
.72083 .87501 Mdot
.72256 .86907 Mdot
.72421 .86298 Mdot
.72577 .85674 Mdot
.72724 .85036 Mdot
.72861 .84384 Mdot
.7299 .83718 Mdot
.73109 .83039 Mdot
.73219 .82347 Mdot
.7332 .81641 Mdot
.73411 .80923 Mdot
.73493 .80193 Mdot
.73566 .79451 Mdot
.73629 .78696 Mdot
.73683 .77931 Mdot
.73727 .77154 Mdot
.73762 .76366 Mdot
.73787 .75568 Mdot
.73803 .74759 Mdot
.73809 .73941 Mdot
.73806 .73113 Mdot
.73793 .72276 Mdot
.73771 .71429 Mdot
.73739 .70575 Mdot
.73698 .69712 Mdot
.73647 .68841 Mdot
.73587 .67962 Mdot
.73517 .67077 Mdot
.73438 .66185 Mdot
.7335 .65286 Mdot
.73252 .64381 Mdot
.73145 .6347 Mdot
.73029 .62554 Mdot
.72903 .61633 Mdot
.72768 .60707 Mdot
.72625 .59777 Mdot
.72472 .58843 Mdot
.7231 .57905 Mdot
.72139 .56965 Mdot
.71959 .56021 Mdot
.71771 .55075 Mdot
.71574 .54127 Mdot
.71368 .53178 Mdot
.71154 .52227 Mdot
.70931 .51275 Mdot
.707 .50323 Mdot
.70461 .49371 Mdot
.70213 .48419 Mdot
.69957 .47467 Mdot
.69694 .46517 Mdot
.69422 .45568 Mdot
.69143 .4462 Mdot
.68856 .43675 Mdot
.68561 .42733 Mdot
.68259 .41793 Mdot
.6795 .40856 Mdot
.67634 .39924 Mdot
.6731 .38995 Mdot
.6698 .38071 Mdot
.66643 .37151 Mdot
.66299 .36237 Mdot
.65948 .35328 Mdot
.65592 .34425 Mdot
.65229 .33528 Mdot
.6486 .32638 Mdot
.64485 .31754 Mdot
.64104 .30878 Mdot
.63717 .3001 Mdot
.63325 .2915 Mdot
.62928 .28298 Mdot
.62526 .27454 Mdot
.62118 .2662 Mdot
.61706 .25795 Mdot
.61289 .2498 Mdot
.60867 .24174 Mdot
.60442 .2338 Mdot
.60012 .22595 Mdot
.59578 .21822 Mdot
.5914 .2106 Mdot
.58698 .20309 Mdot
.58253 .19571 Mdot
.57805 .18844 Mdot
.57354 .1813 Mdot
.56899 .17429 Mdot
.56442 .16741 Mdot
.55982 .16066 Mdot
.5552 .15405 Mdot
.55056 .14757 Mdot
.5459 .14124 Mdot
.54122 .13505 Mdot
.53652 .129 Mdot
.53181 .12311 Mdot
.52708 .11736 Mdot
.52234 .11177 Mdot
.5176 .10633 Mdot
.51285 .10105 Mdot
.50809 .09593 Mdot
.50333 .09098 Mdot
.49857 .08618 Mdot
.49381 .08155 Mdot
.48905 .07709 Mdot
.48429 .0728 Mdot
.47954 .06868 Mdot
.4748 .06473 Mdot
.47007 .06095 Mdot
.46536 .05735 Mdot
.46065 .05393 Mdot
.45596 .05069 Mdot
.45129 .04762 Mdot
.44664 .04474 Mdot
.44201 .04204 Mdot
.43741 .03952 Mdot
.43283 .03719 Mdot
.42827 .03504 Mdot
.42374 .03307 Mdot
.41925 .0313 Mdot
.41479 .02971 Mdot
.41036 .02831 Mdot
.40596 .0271 Mdot
.40161 .02607 Mdot
.39729 .02524 Mdot
.39302 .0246 Mdot
.38878 .02415 Mdot
.3846 .02388 Mdot
.38045 .02381 Mdot
.37636 .02393 Mdot
.37232 .02424 Mdot
.36832 .02474 Mdot
.36438 .02543 Mdot
.36049 .0263 Mdot
.35666 .02737 Mdot
.35289 .02863 Mdot
.34918 .03008 Mdot
.34552 .03171 Mdot
.34193 .03353 Mdot
.3384 .03554 Mdot
.33494 .03773 Mdot
.33154 .04011 Mdot
.32821 .04267 Mdot
.32494 .04542 Mdot
.32175 .04835 Mdot
.31863 .05145 Mdot
.31558 .05474 Mdot
.31261 .05821 Mdot
.30971 .06185 Mdot
.30688 .06567 Mdot
.30414 .06966 Mdot
.30147 .07382 Mdot
.29888 .07815 Mdot
.29637 .08266 Mdot
.29394 .08733 Mdot
.2916 .09216 Mdot
.28934 .09716 Mdot
.28716 .10232 Mdot
.28507 .10763 Mdot
.28306 .11311 Mdot
.28115 .11874 Mdot
.27931 .12452 Mdot
.27757 .13045 Mdot
.27592 .13653 Mdot
.27435 .14276 Mdot
.27288 .14913 Mdot
.27149 .15563 Mdot
.2702 .16228 Mdot
.269 .16906 Mdot
.26789 .17598 Mdot
.26688 .18302 Mdot
.26596 .19019 Mdot
.26513 .19748 Mdot
.2644 .2049 Mdot
.26376 .21243 Mdot
.26321 .22008 Mdot
.26276 .22784 Mdot
.2624 .23571 Mdot
.26214 .24368 Mdot
.26198 .25176 Mdot
.26191 .25994 Mdot
.26193 .26821 Mdot
.26205 .27657 Mdot
.26227 .28503 Mdot
.26258 .29357 Mdot
.26298 .30219 Mdot
.26348 .3109 Mdot
.26408 .31967 Mdot
.26477 .32852 Mdot
.26555 .33744 Mdot
.26643 .34643 Mdot
.2674 .35547 Mdot
.26846 .36457 Mdot
.26962 .37373 Mdot
.27087 .38294 Mdot
.27221 .39219 Mdot
.27364 .40149 Mdot
.27516 .41083 Mdot
.27677 .4202 Mdot
.27847 .4296 Mdot
.28026 .43904 Mdot
.28214 .44849 Mdot
.2841 .45797 Mdot
.28615 .46747 Mdot
.28829 .47697 Mdot
.29051 .48649 Mdot
.29281 .49601 Mdot
.2952 .50553 Mdot
.29767 .51506 Mdot
.30022 .52457 Mdot
.30285 .53408 Mdot
.30556 .54357 Mdot
.30835 .55304 Mdot
.31121 .5625 Mdot
.31415 .57193 Mdot
.31716 .58132 Mdot
.32025 .59069 Mdot
.32341 .60002 Mdot
.32664 .60931 Mdot
.32994 .61856 Mdot
.3333 .62776 Mdot
.33674 .63691 Mdot
.34023 .646 Mdot
.3438 .65504 Mdot
.34742 .66401 Mdot
.35111 .67292 Mdot
.35485 .68176 Mdot
.35866 .69052 Mdot
.36252 .69921 Mdot
.36643 .70782 Mdot
.3704 .71635 Mdot
.37442 .72479 Mdot
.37849 .73314 Mdot
.38261 .7414 Mdot
.38678 .74956 Mdot
.39099 .75762 Mdot
.39524 .76558 Mdot
.39954 .77343 Mdot
.40388 .78117 Mdot
.40825 .7888 Mdot
.41267 .79631 Mdot
.41711 .80371 Mdot
.42159 .81098 Mdot
.4261 .81813 Mdot
.43065 .82516 Mdot
.43521 .83205 Mdot
.43981 .83881 Mdot
.44443 .84543 Mdot
.44907 .85192 Mdot
.45373 .85826 Mdot
.45841 .86446 Mdot
.46311 .87052 Mdot
.46782 .87643 Mdot
.47254 .88219 Mdot
.47728 .88779 Mdot
.48202 .89324 Mdot
.48677 .89853 Mdot
.49153 .90366 Mdot
.49629 .90864 Mdot
.50105 .91344 Mdot
.50582 .91809 Mdot
.51057 .92256 Mdot
.51533 .92687 Mdot
.52008 .931 Mdot
.52482 .93496 Mdot
.52955 .93875 Mdot
.53427 .94237 Mdot
.53897 .9458 Mdot
.54366 .94906 Mdot
.54833 .95214 Mdot
.55299 .95504 Mdot
.55762 .95775 Mdot
.56223 .96029 Mdot
.56681 .96264 Mdot
.57137 .9648 Mdot
.5759 .96678 Mdot
.58039 .96857 Mdot
.58486 .97017 Mdot
.58929 .97159 Mdot
.59369 .97281 Mdot
.59805 .97385 Mdot
.60237 .9747 Mdot
.60665 .97536 Mdot
.61088 .97583 Mdot
.61507 .9761 Mdot
.61922 .97619 Mdot
.62332 .97609 Mdot
.62736 .97579 Mdot
.63136 .97531 Mdot
.63531 .97464 Mdot
.6392 .97377 Mdot
.64303 .97272 Mdot
.64681 .97148 Mdot
.65053 .97005 Mdot
.65419 .96843 Mdot
.65779 .96662 Mdot
.66132 .96463 Mdot
.66479 .96245 Mdot
.66819 .96008 Mdot
.67153 .95754 Mdot
.6748 .95481 Mdot
.678 .95189 Mdot
.68112 .9488 Mdot
.68418 .94553 Mdot
.68716 .94208 Mdot
.69007 .93845 Mdot
.6929 .93464 Mdot
.69565 .93067 Mdot
.69832 .92652 Mdot
.70092 .9222 Mdot
.70343 .91771 Mdot
.70587 .91305 Mdot
.70822 .90823 Mdot
.71048 .90325 Mdot
.71267 .8981 Mdot
.71477 .89279 Mdot
.71678 .88733 Mdot
.71871 .88172 Mdot
.72054 .87595 Mdot
.72229 .87002 Mdot
.72396 .86396 Mdot
.72553 .85774 Mdot
.72701 .85139 Mdot
.7284 .84489 Mdot
.7297 .83825 Mdot
.73091 .83148 Mdot
.73202 .82458 Mdot
.73304 .81755 Mdot
.73397 .81039 Mdot
.73481 .8031 Mdot
.73555 .7957 Mdot
.7362 .78817 Mdot
.73675 .78053 Mdot
.73721 .77278 Mdot
.73757 .76492 Mdot
.73784 .75696 Mdot
.73801 .74889 Mdot
.73809 .74072 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
The more extreme cases can be quite illuminating.  For example, we can set the probability of Method A returning a "0" to be 0 (p0A=0) and the probability of Method B returning a "0" to be 0.4 (p0B=0.4). The quantum probability can often far exceed the classical probability.
:[font = input; preserveAspect; startGroup]
PhaseDiagram[0, .4];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 35; pictureWidth = 196; pictureHeight = 196; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.02381 .02381 Mdot
.02385 .02385 Mdot
.02396 .02396 Mdot
.02415 .02414 Mdot
.02442 .02438 Mdot
.02476 .02469 Mdot
.02518 .02506 Mdot
.02567 .02549 Mdot
.02624 .02598 Mdot
.02689 .02651 Mdot
.02761 .0271 Mdot
.0284 .02774 Mdot
.02927 .02842 Mdot
.03021 .02915 Mdot
.03123 .02992 Mdot
.03232 .03073 Mdot
.03348 .03158 Mdot
.03471 .03247 Mdot
.03602 .0334 Mdot
.0374 .03436 Mdot
.03885 .03536 Mdot
.04036 .03639 Mdot
.04195 .03745 Mdot
.04361 .03854 Mdot
.04533 .03966 Mdot
.04713 .04081 Mdot
.04899 .04199 Mdot
.05091 .04319 Mdot
.0529 .04442 Mdot
.05496 .04568 Mdot
.05708 .04696 Mdot
.05926 .04826 Mdot
.06151 .04958 Mdot
.06381 .05093 Mdot
.06618 .0523 Mdot
.0686 .05369 Mdot
.07108 .0551 Mdot
.07363 .05653 Mdot
.07622 .05798 Mdot
.07887 .05946 Mdot
.08158 .06094 Mdot
.08434 .06245 Mdot
.08715 .06398 Mdot
.09001 .06552 Mdot
.09292 .06709 Mdot
.09588 .06867 Mdot
.09889 .07026 Mdot
.10195 .07188 Mdot
.10504 .07351 Mdot
.10819 .07516 Mdot
.11137 .07682 Mdot
.1146 .0785 Mdot
.11786 .0802 Mdot
.12117 .08191 Mdot
.12451 .08364 Mdot
.12789 .08538 Mdot
.1313 .08714 Mdot
.13474 .08892 Mdot
.13822 .09071 Mdot
.14173 .09252 Mdot
.14527 .09434 Mdot
.14883 .09618 Mdot
.15242 .09804 Mdot
.15603 .09991 Mdot
.15967 .1018 Mdot
.16333 .1037 Mdot
.16701 .10562 Mdot
.17071 .10756 Mdot
.17443 .10951 Mdot
.17816 .11148 Mdot
.18191 .11347 Mdot
.18567 .11547 Mdot
.18944 .11749 Mdot
.19322 .11953 Mdot
.19701 .12159 Mdot
.20081 .12366 Mdot
.20461 .12575 Mdot
.20842 .12786 Mdot
.21223 .12999 Mdot
.21604 .13213 Mdot
.21985 .1343 Mdot
.22365 .13648 Mdot
.22746 .13869 Mdot
.23125 .14091 Mdot
.23505 .14315 Mdot
.23883 .14542 Mdot
.2426 .1477 Mdot
.24636 .15001 Mdot
.25011 .15233 Mdot
.25384 .15468 Mdot
.25756 .15705 Mdot
.26126 .15945 Mdot
.26495 .16186 Mdot
.26861 .1643 Mdot
.27225 .16677 Mdot
.27586 .16925 Mdot
.27946 .17177 Mdot
.28302 .17431 Mdot
.28656 .17687 Mdot
.29007 .17946 Mdot
.29355 .18208 Mdot
.297 .18472 Mdot
.30041 .1874 Mdot
.30379 .1901 Mdot
.30714 .19283 Mdot
.31045 .19559 Mdot
.31372 .19838 Mdot
.31695 .2012 Mdot
.32013 .20406 Mdot
.32328 .20694 Mdot
.32638 .20986 Mdot
.32944 .21282 Mdot
.33245 .21581 Mdot
.33541 .21883 Mdot
.33833 .22189 Mdot
.3412 .22499 Mdot
.34401 .22813 Mdot
.34677 .2313 Mdot
.34948 .23452 Mdot
.35214 .23777 Mdot
.35474 .24107 Mdot
.35729 .24441 Mdot
.35977 .24779 Mdot
.3622 .25122 Mdot
.36457 .2547 Mdot
.36688 .25822 Mdot
.36913 .26179 Mdot
.37132 .26541 Mdot
.37345 .26908 Mdot
.37551 .2728 Mdot
.3775 .27657 Mdot
.37943 .2804 Mdot
.3813 .28429 Mdot
.3831 .28823 Mdot
.38483 .29223 Mdot
.38649 .29629 Mdot
.38808 .30041 Mdot
.38961 .30459 Mdot
.39106 .30884 Mdot
.39244 .31316 Mdot
.39376 .31754 Mdot
.395 .32199 Mdot
.39616 .32652 Mdot
.39726 .33111 Mdot
.39828 .33579 Mdot
.39923 .34053 Mdot
.4001 .34536 Mdot
.4009 .35027 Mdot
.40163 .35526 Mdot
.40228 .36034 Mdot
.40286 .3655 Mdot
.40336 .37076 Mdot
.40378 .3761 Mdot
.40413 .38154 Mdot
.4044 .38708 Mdot
.4046 .39272 Mdot
.40472 .39845 Mdot
.40476 .40429 Mdot
.40473 .41024 Mdot
.40462 .4163 Mdot
.40444 .42246 Mdot
.40418 .42874 Mdot
.40384 .43514 Mdot
.40343 .44166 Mdot
.40294 .44831 Mdot
.40238 .45507 Mdot
.40174 .46197 Mdot
.40103 .469 Mdot
.40024 .47616 Mdot
.39937 .48346 Mdot
.39844 .49089 Mdot
.39743 .49847 Mdot
.39634 .5062 Mdot
.39519 .51407 Mdot
.39396 .5221 Mdot
.39266 .53027 Mdot
.39129 .5386 Mdot
.38984 .54709 Mdot
.38833 .55574 Mdot
.38675 .56455 Mdot
.3851 .57353 Mdot
.38338 .58266 Mdot
.38159 .59197 Mdot
.37974 .60143 Mdot
.37781 .61107 Mdot
.37583 .62087 Mdot
.37378 .63083 Mdot
.37166 .64096 Mdot
.36949 .65124 Mdot
.36725 .66169 Mdot
.36495 .67229 Mdot
.36259 .68304 Mdot
.36017 .69393 Mdot
.35769 .70495 Mdot
.35515 .71611 Mdot
.35256 .72738 Mdot
.34991 .73876 Mdot
.34721 .75023 Mdot
.34445 .76177 Mdot
.34165 .77338 Mdot
.33879 .78503 Mdot
.33588 .7967 Mdot
.33293 .80836 Mdot
.32992 .81998 Mdot
.32687 .83155 Mdot
.32378 .84302 Mdot
.32064 .85436 Mdot
.31746 .86552 Mdot
.31423 .87647 Mdot
.31097 .88717 Mdot
.30767 .89754 Mdot
.30433 .90756 Mdot
.30096 .91715 Mdot
.29755 .92627 Mdot
.2941 .93483 Mdot
.29063 .94279 Mdot
.28712 .95008 Mdot
.28359 .95661 Mdot
.28003 .96233 Mdot
.27644 .96716 Mdot
.27283 .97103 Mdot
.26919 .97387 Mdot
.26553 .97561 Mdot
.26185 .97619 Mdot
.25815 .97555 Mdot
.25444 .97364 Mdot
.25071 .97041 Mdot
.24696 .96583 Mdot
.2432 .95986 Mdot
.23943 .95248 Mdot
.23565 .94369 Mdot
.23186 .93349 Mdot
.22806 .92189 Mdot
.22426 .90893 Mdot
.22045 .89465 Mdot
.21665 .8791 Mdot
.21284 .86234 Mdot
.20903 .84445 Mdot
.20522 .82552 Mdot
.20142 .80563 Mdot
.19762 .78488 Mdot
.19383 .76339 Mdot
.19004 .74126 Mdot
.18627 .7186 Mdot
.18251 .69553 Mdot
.17876 .67215 Mdot
.17502 .64857 Mdot
.1713 .62489 Mdot
.1676 .60123 Mdot
.16392 .57765 Mdot
.16025 .55427 Mdot
.15661 .53115 Mdot
.15299 .50837 Mdot
.1494 .48599 Mdot
.14583 .46407 Mdot
.14229 .44267 Mdot
.13878 .42181 Mdot
.1353 .40154 Mdot
.13185 .38188 Mdot
.12843 .36286 Mdot
.12504 .3445 Mdot
.1217 .3268 Mdot
.11839 .30977 Mdot
.11511 .29341 Mdot
.11188 .27772 Mdot
.10869 .26269 Mdot
.10554 .24832 Mdot
.10244 .23459 Mdot
.09937 .2215 Mdot
.09636 .20902 Mdot
.09339 .19715 Mdot
.09047 .18586 Mdot
.0876 .17514 Mdot
.08478 .16496 Mdot
.08202 .15531 Mdot
.0793 .14617 Mdot
.07664 .13753 Mdot
.07403 .12935 Mdot
.07149 .12163 Mdot
.06899 .11434 Mdot
.06656 .10746 Mdot
.06418 .10099 Mdot
.06187 .09489 Mdot
.05961 .08916 Mdot
.05742 .08377 Mdot
.05529 .07871 Mdot
.05323 .07397 Mdot
.05123 .06953 Mdot
.04929 .06538 Mdot
.04742 .0615 Mdot
.04562 .05787 Mdot
.04388 .0545 Mdot
.04221 .05136 Mdot
.04061 .04845 Mdot
.03908 .04575 Mdot
.03762 .04325 Mdot
.03623 .04095 Mdot
.03492 .03883 Mdot
.03367 .03689 Mdot
.0325 .03511 Mdot
.0314 .03349 Mdot
.03037 .03202 Mdot
.02941 .0307 Mdot
.02853 .02951 Mdot
.02773 .02845 Mdot
.027 .02752 Mdot
.02634 .0267 Mdot
.02576 .026 Mdot
.02525 .0254 Mdot
.02482 .02491 Mdot
.02447 .02451 Mdot
.02419 .02421 Mdot
.02399 .02399 Mdot
.02386 .02386 Mdot
.02381 .02381 Mdot
.02384 .02384 Mdot
.02394 .02394 Mdot
.02412 .0241 Mdot
.02437 .02434 Mdot
.0247 .02464 Mdot
.02511 .025 Mdot
.02559 .02542 Mdot
.02615 .02589 Mdot
.02678 .02642 Mdot
.02749 .027 Mdot
.02827 .02763 Mdot
.02913 .02831 Mdot
.03006 .02903 Mdot
.03106 .02979 Mdot
.03214 .0306 Mdot
.03329 .03145 Mdot
.03451 .03233 Mdot
.03581 .03325 Mdot
.03717 .03421 Mdot
.03861 .0352 Mdot
.04012 .03622 Mdot
.04169 .03728 Mdot
.04334 .03837 Mdot
.04505 .03948 Mdot
.04684 .04063 Mdot
.04869 .0418 Mdot
.0506 .043 Mdot
.05258 .04422 Mdot
.05463 .04548 Mdot
.05674 .04675 Mdot
.05891 .04805 Mdot
.06114 .04937 Mdot
.06344 .05071 Mdot
.0658 .05208 Mdot
.06821 .05347 Mdot
.07069 .05488 Mdot
.07322 .0563 Mdot
.0758 .05775 Mdot
.07845 .05922 Mdot
.08115 .06071 Mdot
.0839 .06221 Mdot
.0867 .06374 Mdot
.08955 .06528 Mdot
.09246 .06684 Mdot
.09541 .06841 Mdot
.09841 .07001 Mdot
.10146 .07162 Mdot
.10455 .07325 Mdot
.10768 .07489 Mdot
.11086 .07655 Mdot
.11408 .07823 Mdot
.11734 .07992 Mdot
.12064 .08163 Mdot
.12397 .08336 Mdot
.12735 .0851 Mdot
.13075 .08686 Mdot
.13419 .08863 Mdot
.13767 .09042 Mdot
.14117 .09223 Mdot
.1447 .09405 Mdot
.14826 .09589 Mdot
.15185 .09774 Mdot
.15546 .09961 Mdot
.15909 .1015 Mdot
.16275 .1034 Mdot
.16643 .10532 Mdot
.17012 .10725 Mdot
.17384 .1092 Mdot
.17757 .11117 Mdot
.18131 .11315 Mdot
.18507 .11515 Mdot
.18884 .11717 Mdot
.19262 .11921 Mdot
.19641 .12126 Mdot
.20021 .12333 Mdot
.20401 .12542 Mdot
.20781 .12752 Mdot
.21162 .12965 Mdot
.21543 .13179 Mdot
.21924 .13395 Mdot
.22305 .13613 Mdot
.22685 .13833 Mdot
.23065 .14055 Mdot
.23444 .14279 Mdot
.23823 .14505 Mdot
.242 .14734 Mdot
.24576 .14964 Mdot
.24951 .15196 Mdot
.25325 .15431 Mdot
.25697 .15667 Mdot
.26068 .15906 Mdot
.26436 .16148 Mdot
.26803 .16391 Mdot
.27167 .16637 Mdot
.27529 .16886 Mdot
.27889 .17136 Mdot
.28246 .1739 Mdot
.286 .17646 Mdot
.28952 .17905 Mdot
.293 .18166 Mdot
.29645 .1843 Mdot
.29987 .18697 Mdot
.30326 .18966 Mdot
.30661 .19239 Mdot
.30992 .19515 Mdot
.3132 .19793 Mdot
.31643 .20075 Mdot
.31963 .2036 Mdot
.32278 .20648 Mdot
.32589 .2094 Mdot
.32895 .21234 Mdot
.33197 .21533 Mdot
.33495 .21835 Mdot
.33787 .2214 Mdot
.34074 .22449 Mdot
.34357 .22762 Mdot
.34634 .23079 Mdot
.34906 .234 Mdot
.35172 .23725 Mdot
.35433 .24054 Mdot
.35689 .24387 Mdot
.35938 .24725 Mdot
.36182 .25067 Mdot
.3642 .25414 Mdot
.36652 .25765 Mdot
.36878 .26122 Mdot
.37098 .26483 Mdot
.37311 .26849 Mdot
.37518 .2722 Mdot
.37719 .27597 Mdot
.37913 .27979 Mdot
.38101 .28366 Mdot
.38281 .2876 Mdot
.38456 .29159 Mdot
.38623 .29564 Mdot
.38783 .29975 Mdot
.38937 .30392 Mdot
.39083 .30816 Mdot
.39223 .31246 Mdot
.39355 .31684 Mdot
.3948 .32128 Mdot
.39598 .32579 Mdot
.39709 .33038 Mdot
.39812 .33504 Mdot
.39908 .33977 Mdot
.39997 .34459 Mdot
.40078 .34948 Mdot
.40152 .35446 Mdot
.40218 .35953 Mdot
.40277 .36468 Mdot
.40328 .36992 Mdot
.40372 .37525 Mdot
.40408 .38067 Mdot
.40436 .38619 Mdot
.40457 .39181 Mdot
.4047 .39753 Mdot
.40476 .40336 Mdot
.40474 .40928 Mdot
.40464 .41532 Mdot
.40447 .42147 Mdot
.40422 .42774 Mdot
.4039 .43412 Mdot
.4035 .44062 Mdot
.40302 .44724 Mdot
.40247 .45399 Mdot
.40185 .46086 Mdot
.40114 .46787 Mdot
.40037 .47501 Mdot
.39952 .48228 Mdot
.39859 .4897 Mdot
.39759 .49726 Mdot
.39652 .50496 Mdot
.39538 .51281 Mdot
.39416 .52081 Mdot
.39287 .52896 Mdot
.39151 .53727 Mdot
.39008 .54573 Mdot
.38858 .55435 Mdot
.38701 .56314 Mdot
.38536 .57209 Mdot
.38366 .5812 Mdot
.38188 .59047 Mdot
.38003 .59991 Mdot
.37812 .60952 Mdot
.37615 .61929 Mdot
.37411 .62923 Mdot
.372 .63933 Mdot
.36984 .64959 Mdot
.36761 .66002 Mdot
.36532 .67059 Mdot
.36297 .68131 Mdot
.36055 .69218 Mdot
.35809 .70319 Mdot
.35556 .71432 Mdot
.35298 .72558 Mdot
.35034 .73694 Mdot
.34764 .74839 Mdot
.3449 .75993 Mdot
.3421 .77153 Mdot
.33925 .78317 Mdot
.33635 .79484 Mdot
.3334 .8065 Mdot
.3304 .81814 Mdot
.32736 .82971 Mdot
.32427 .8412 Mdot
.32114 .85256 Mdot
.31797 .86376 Mdot
.31475 .87475 Mdot
.31149 .88548 Mdot
.3082 .89591 Mdot
.30486 .90599 Mdot
.3015 .91566 Mdot
.29809 .92485 Mdot
.29465 .93351 Mdot
.29118 .94157 Mdot
.28768 .94896 Mdot
.28415 .95562 Mdot
.2806 .96148 Mdot
.27701 .96645 Mdot
.2734 .97048 Mdot
.26977 .97348 Mdot
.26611 .97541 Mdot
.26244 .97618 Mdot
.25874 .97574 Mdot
.25503 .97404 Mdot
.2513 .97102 Mdot
.24756 .96665 Mdot
.2438 .9609 Mdot
.24003 .95375 Mdot
.23625 .94518 Mdot
.23246 .9352 Mdot
.22867 .92383 Mdot
.22487 .91109 Mdot
.22106 .89701 Mdot
.21725 .88166 Mdot
.21344 .86509 Mdot
.20963 .84737 Mdot
.20583 .8286 Mdot
.20202 .80885 Mdot
.19822 .78824 Mdot
.19443 .76686 Mdot
.19065 .74483 Mdot
.18687 .72224 Mdot
.18311 .69923 Mdot
.17936 .67589 Mdot
.17562 .65233 Mdot
.1719 .62867 Mdot
.16819 .60499 Mdot
.1645 .5814 Mdot
.16084 .55798 Mdot
.15719 .53481 Mdot
.15357 .51197 Mdot
.14997 .48953 Mdot
.1464 .46753 Mdot
.14285 .44604 Mdot
.13934 .42509 Mdot
.13585 .40473 Mdot
.13239 .38497 Mdot
.12897 .36585 Mdot
.12558 .34738 Mdot
.12223 .32957 Mdot
.11891 .31243 Mdot
.11563 .29597 Mdot
.11239 .28017 Mdot
.1092 .26504 Mdot
.10604 .25057 Mdot
.10293 .23674 Mdot
.09986 .22354 Mdot
.09684 .21097 Mdot
.09386 .199 Mdot
.09093 .18762 Mdot
.08806 .17681 Mdot
.08523 .16654 Mdot
.08245 .15681 Mdot
.07973 .1476 Mdot
.07706 .13887 Mdot
.07445 .13062 Mdot
.07189 .12283 Mdot
.06939 .11547 Mdot
.06694 .10853 Mdot
.06456 .10199 Mdot
.06223 .09584 Mdot
.05997 .09005 Mdot
.05777 .0846 Mdot
.05563 .0795 Mdot
.05355 .07471 Mdot
.05154 .07022 Mdot
.04959 .06602 Mdot
.04771 .0621 Mdot
.0459 .05843 Mdot
.04415 .05502 Mdot
.04247 .05185 Mdot
.04086 .0489 Mdot
.03932 .04617 Mdot
.03785 .04364 Mdot
.03645 .04131 Mdot
.03512 .03916 Mdot
.03386 .03719 Mdot
.03268 .03538 Mdot
.03157 .03374 Mdot
.03053 .03225 Mdot
.02956 .0309 Mdot
.02867 .02969 Mdot
.02785 .02861 Mdot
.02711 .02766 Mdot
.02644 .02683 Mdot
.02585 .02611 Mdot
.02533 .02549 Mdot
.02489 .02498 Mdot
.02452 .02457 Mdot
.02423 .02425 Mdot
.02401 .02402 Mdot
.02388 .02388 Mdot
.02381 .02381 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
ComparisonPlot[0, .4];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147151 0.588653 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13245 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25018 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36791 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .48564 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60337 1 0 0 Minner Mrotsboxa
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13245 m
1 .13245 L
s
P
p
0 0 .5 r
.001 w
0 .25018 m
1 .25018 L
s
P
p
0 0 .5 r
.001 w
0 .36791 m
1 .36791 L
s
P
p
0 0 .5 r
.001 w
0 .48564 m
1 .48564 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .13245 m
.00625 .13245 L
s
P
[(0.2)] -0.0125 .13245 1 0 0 Minner Mrotshowa
p
.002 w
0 .25018 m
.00625 .25018 L
s
P
[(0.4)] -0.0125 .25018 1 0 0 Minner Mrotshowa
p
.002 w
0 .36791 m
.00625 .36791 L
s
P
[(0.6)] -0.0125 .36791 1 0 0 Minner Mrotshowa
p
.002 w
0 .48564 m
.00625 .48564 L
s
P
[(0.8)] -0.0125 .48564 1 0 0 Minner Mrotshowa
p
.002 w
0 .60337 m
.00625 .60337 L
s
P
[(1)] -0.0125 .60337 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .06181 m
.00375 .06181 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .1089 m
.00375 .1089 L
s
P
p
.001 w
0 .15599 m
.00375 .15599 L
s
P
p
.001 w
0 .17954 m
.00375 .17954 L
s
P
p
.001 w
0 .20308 m
.00375 .20308 L
s
P
p
.001 w
0 .22663 m
.00375 .22663 L
s
P
p
.001 w
0 .27372 m
.00375 .27372 L
s
P
p
.001 w
0 .29727 m
.00375 .29727 L
s
P
p
.001 w
0 .32081 m
.00375 .32081 L
s
P
p
.001 w
0 .34436 m
.00375 .34436 L
s
P
p
.001 w
0 .39145 m
.00375 .39145 L
s
P
p
.001 w
0 .415 m
.00375 .415 L
s
P
p
.001 w
0 .43855 m
.00375 .43855 L
s
P
p
.001 w
0 .46209 m
.00375 .46209 L
s
P
p
.001 w
0 .50918 m
.00375 .50918 L
s
P
p
.001 w
0 .53273 m
.00375 .53273 L
s
P
p
.001 w
0 .55628 m
.00375 .55628 L
s
P
p
.001 w
0 .57982 m
.00375 .57982 L
s
P
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .13245 m
1 .13245 L
s
P
p
.002 w
.99375 .25018 m
1 .25018 L
s
P
p
.002 w
.99375 .36791 m
1 .36791 L
s
P
p
.002 w
.99375 .48564 m
1 .48564 L
s
P
p
.002 w
.99375 .60337 m
1 .60337 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .06181 m
1 .06181 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .1089 m
1 .1089 L
s
P
p
.001 w
.99625 .15599 m
1 .15599 L
s
P
p
.001 w
.99625 .17954 m
1 .17954 L
s
P
p
.001 w
.99625 .20308 m
1 .20308 L
s
P
p
.001 w
.99625 .22663 m
1 .22663 L
s
P
p
.001 w
.99625 .27372 m
1 .27372 L
s
P
p
.001 w
.99625 .29727 m
1 .29727 L
s
P
p
.001 w
.99625 .32081 m
1 .32081 L
s
P
p
.001 w
.99625 .34436 m
1 .34436 L
s
P
p
.001 w
.99625 .39145 m
1 .39145 L
s
P
p
.001 w
.99625 .415 m
1 .415 L
s
P
p
.001 w
.99625 .43855 m
1 .43855 L
s
P
p
.001 w
.99625 .46209 m
1 .46209 L
s
P
p
.001 w
.99625 .50918 m
1 .50918 L
s
P
p
.001 w
.99625 .53273 m
1 .53273 L
s
P
p
.001 w
.99625 .55628 m
1 .55628 L
s
P
p
.001 w
.99625 .57982 m
1 .57982 L
s
P
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .01472 m
.02505 .01473 L
.02629 .01478 L
.02753 .01485 L
.02877 .01496 L
.03001 .01509 L
.03125 .01524 L
.03373 .01563 L
.03869 .01668 L
.04365 .01806 L
.05357 .02163 L
.06349 .02608 L
.10317 .04995 L
.14286 .08106 L
.18254 .12041 L
.20238 .14457 L
.22222 .17307 L
.24206 .20751 L
.2619 .25018 L
.28175 .3042 L
.30159 .37327 L
.32143 .45909 L
.34127 .55119 L
.34623 .57092 L
.34871 .57957 L
.35119 .58716 L
.35367 .59352 L
.35491 .59618 L
.35615 .59846 L
.35739 .60033 L
.35863 .60178 L
.35987 .60277 L
.36111 .60329 L
.36235 .60332 L
.36359 .60283 L
.36483 .60182 L
.36607 .60026 L
.36855 .59545 L
.36979 .59219 L
.37103 .58834 L
.37599 .56712 L
.38095 .53703 L
.39087 .45588 L
.40079 .36126 L
.41071 .27029 L
.42063 .19354 L
.43056 .13421 L
.43552 .11075 L
.44048 .09096 L
.44544 .07443 L
Mistroke
.4504 .06075 L
.45536 .04955 L
.46032 .04046 L
.46528 .03318 L
.47024 .02745 L
.4752 .02303 L
.48016 .01973 L
.48264 .01845 L
.48512 .01738 L
.4876 .01651 L
.49008 .01584 L
.49132 .01556 L
.49256 .01533 L
.4938 .01514 L
.49504 .01498 L
.49628 .01486 L
.49752 .01478 L
.49876 .01473 L
.5 .01472 L
.50124 .01473 L
.50248 .01478 L
.50372 .01485 L
.50496 .01496 L
.5062 .01509 L
.50744 .01524 L
.50992 .01563 L
.51488 .01668 L
.51984 .01806 L
.52976 .02163 L
.53968 .02608 L
.57937 .04995 L
.61905 .08106 L
.65873 .12041 L
.67857 .14457 L
.69841 .17307 L
.71825 .20751 L
.7381 .25018 L
.75794 .3042 L
.77778 .37327 L
.79762 .45909 L
.80754 .50606 L
.81746 .55119 L
.82242 .57092 L
.8249 .57957 L
.82738 .58716 L
.82986 .59352 L
.83234 .59846 L
.83358 .60033 L
.83482 .60178 L
.83606 .60277 L
Mistroke
.8373 .60329 L
.83854 .60332 L
.83978 .60283 L
.84102 .60182 L
.84226 .60026 L
.8435 .59814 L
.84474 .59545 L
.84722 .58834 L
.8497 .57889 L
.85218 .56712 L
.85714 .53703 L
.86706 .45588 L
.87698 .36126 L
.8869 .27029 L
.89683 .19354 L
.90675 .13421 L
.91171 .11075 L
.91667 .09096 L
.92659 .06075 L
.93155 .04955 L
.93651 .04046 L
.94147 .03318 L
.94643 .02745 L
.95139 .02303 L
.95635 .01973 L
.95883 .01845 L
.96131 .01738 L
.96379 .01651 L
.96627 .01584 L
.96751 .01556 L
.96875 .01533 L
.96999 .01514 L
.97123 .01498 L
.97247 .01486 L
.97371 .01478 L
.97495 .01473 L
.97619 .01472 L
Mfstroke
P
P
p
p
.02 w
.02381 .01472 m
.02505 .01473 L
.02629 .01478 L
.02753 .01486 L
.02877 .01497 L
.03001 .01511 L
.03125 .01528 L
.03373 .01572 L
.03621 .01629 L
.03869 .01698 L
.04365 .01873 L
.05357 .02368 L
.06349 .03049 L
.08333 .0492 L
.10317 .07358 L
.14286 .13245 L
.18254 .19131 L
.20238 .21569 L
.2123 .22585 L
.22222 .2344 L
.23214 .24121 L
.2371 .24393 L
.24206 .24616 L
.24702 .24791 L
.2495 .2486 L
.25198 .24917 L
.25446 .24961 L
.2557 .24978 L
.25694 .24992 L
.25818 .25003 L
.25942 .25011 L
.26066 .25016 L
.2619 .25018 L
.26314 .25016 L
.26438 .25011 L
.26562 .25003 L
.26687 .24992 L
.26935 .24961 L
.27183 .24917 L
.27431 .2486 L
.27679 .24791 L
.28175 .24616 L
.29167 .24121 L
.30159 .2344 L
.32143 .21569 L
.34127 .19131 L
.38095 .13245 L
.42063 .07358 L
.44048 .0492 L
.4504 .03904 L
Mistroke
.46032 .03049 L
.47024 .02368 L
.48016 .01873 L
.48512 .01698 L
.4876 .01629 L
.49008 .01572 L
.49256 .01528 L
.4938 .01511 L
.49504 .01497 L
.49628 .01486 L
.49752 .01478 L
.49876 .01473 L
.5 .01472 L
.50124 .01473 L
.50248 .01478 L
.50372 .01486 L
.50496 .01497 L
.5062 .01511 L
.50744 .01528 L
.50992 .01572 L
.5124 .01629 L
.51488 .01698 L
.51984 .01873 L
.52976 .02368 L
.53968 .03049 L
.55952 .0492 L
.57937 .07358 L
.61905 .13245 L
.65873 .19131 L
.67857 .21569 L
.68849 .22585 L
.69841 .2344 L
.70833 .24121 L
.71329 .24393 L
.71825 .24616 L
.72321 .24791 L
.72569 .2486 L
.72817 .24917 L
.73065 .24961 L
.73189 .24978 L
.73313 .24992 L
.73437 .25003 L
.73562 .25011 L
.73686 .25016 L
.7381 .25018 L
.73934 .25016 L
.74058 .25011 L
.74182 .25003 L
.74306 .24992 L
.74554 .24961 L
Mistroke
.74802 .24917 L
.7505 .2486 L
.75298 .24791 L
.75794 .24616 L
.76786 .24121 L
.77778 .2344 L
.79762 .21569 L
.81746 .19131 L
.85714 .13245 L
.89683 .07358 L
.91667 .0492 L
.93651 .03049 L
.94643 .02368 L
.95139 .02096 L
.95635 .01873 L
.96131 .01698 L
.96379 .01629 L
.96627 .01572 L
.96875 .01528 L
.96999 .01511 L
.97123 .01497 L
.97247 .01486 L
.97371 .01478 L
.97495 .01473 L
.97619 .01472 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me! p0A=0.35, p0B=0.8
:[font = text; inactive; preserveAspect]
You can work out the probability formulae for fixed p0A and p0B but variable phi. This helps to determine the regime in which one exceeds the other.
:[font = input; preserveAspect; startGroup]
Pquantum[phi, 7/20, 4/5] // Together
:[font = output; output; inactive; preserveAspect; endGroup]
(-23 + 9*Cos[2*phi] + 8*7^(1/2)*Sin[2*phi])/
 
  (4*(-10 + 2*7^(1/2)*Sin[2*phi] - 13^(1/2)*Sin[2*phi]))
;[o]
     -23 + 9 Cos[2 phi] + 8 Sqrt[7] Sin[2 phi]
----------------------------------------------------
4 (-10 + 2 Sqrt[7] Sin[2 phi] - Sqrt[13] Sin[2 phi])
:[font = input; preserveAspect; startGroup]
Pclassical[phi, 7/20, 4/5]
:[font = output; output; inactive; preserveAspect; endGroup]
23/40 - (9*Cos[2*phi])/40
;[o]
23   9 Cos[2 phi]
-- - ------------
40        40
:[font = input; preserveAspect; startGroup]
PhaseDiagram[7/20, 4/5];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 198; pictureHeight = 198; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.35714 .35714 Mdot
.35719 .3482 Mdot
.35731 .33929 Mdot
.35753 .33041 Mdot
.35783 .32157 Mdot
.35821 .31277 Mdot
.35868 .30401 Mdot
.35924 .2953 Mdot
.35988 .28665 Mdot
.3606 .27806 Mdot
.36141 .26952 Mdot
.36231 .26106 Mdot
.36328 .25267 Mdot
.36435 .24435 Mdot
.36549 .23611 Mdot
.36671 .22796 Mdot
.36802 .21989 Mdot
.36941 .21192 Mdot
.37088 .20405 Mdot
.37243 .19629 Mdot
.37406 .18863 Mdot
.37577 .18109 Mdot
.37755 .17366 Mdot
.37942 .16636 Mdot
.38136 .15918 Mdot
.38338 .15214 Mdot
.38547 .14524 Mdot
.38763 .13847 Mdot
.38987 .13186 Mdot
.39219 .12539 Mdot
.39457 .11909 Mdot
.39703 .11294 Mdot
.39955 .10697 Mdot
.40214 .10116 Mdot
.40481 .09553 Mdot
.40753 .09008 Mdot
.41033 .08481 Mdot
.41319 .07973 Mdot
.41611 .07485 Mdot
.41909 .07017 Mdot
.42213 .06569 Mdot
.42524 .06141 Mdot
.4284 .05735 Mdot
.43162 .0535 Mdot
.4349 .04987 Mdot
.43823 .04646 Mdot
.44161 .04328 Mdot
.44505 .04032 Mdot
.44853 .0376 Mdot
.45207 .03512 Mdot
.45565 .03287 Mdot
.45928 .03087 Mdot
.46295 .02911 Mdot
.46667 .0276 Mdot
.47043 .02634 Mdot
.47423 .02533 Mdot
.47807 .02458 Mdot
.48194 .02408 Mdot
.48586 .02383 Mdot
.4898 .02385 Mdot
.49378 .02413 Mdot
.49779 .02466 Mdot
.50183 .02546 Mdot
.5059 .02652 Mdot
.50999 .02785 Mdot
.51411 .02943 Mdot
.51825 .03128 Mdot
.52241 .03339 Mdot
.52659 .03577 Mdot
.53079 .0384 Mdot
.53501 .04129 Mdot
.53924 .04444 Mdot
.54348 .04785 Mdot
.54774 .05151 Mdot
.552 .05543 Mdot
.55627 .0596 Mdot
.56055 .06402 Mdot
.56483 .06868 Mdot
.56912 .07358 Mdot
.5734 .07873 Mdot
.57769 .08411 Mdot
.58197 .08972 Mdot
.58625 .09557 Mdot
.59052 .10164 Mdot
.59478 .10793 Mdot
.59904 .11444 Mdot
.60328 .12116 Mdot
.60751 .12809 Mdot
.61173 .13522 Mdot
.61593 .14255 Mdot
.62011 .15007 Mdot
.62428 .15778 Mdot
.62842 .16568 Mdot
.63254 .17375 Mdot
.63664 .18199 Mdot
.6407 .19039 Mdot
.64475 .19896 Mdot
.64876 .20767 Mdot
.65274 .21654 Mdot
.65669 .22555 Mdot
.6606 .23469 Mdot
.66448 .24396 Mdot
.66832 .25335 Mdot
.67213 .26286 Mdot
.67589 .27248 Mdot
.67961 .2822 Mdot
.68329 .29201 Mdot
.68692 .30192 Mdot
.69051 .31191 Mdot
.69405 .32198 Mdot
.69754 .33212 Mdot
.70098 .34232 Mdot
.70436 .35258 Mdot
.7077 .36289 Mdot
.71098 .37325 Mdot
.7142 .38364 Mdot
.71737 .39407 Mdot
.72048 .40452 Mdot
.72353 .41499 Mdot
.72652 .42548 Mdot
.72944 .43598 Mdot
.7323 .44648 Mdot
.7351 .45697 Mdot
.73784 .46745 Mdot
.7405 .47793 Mdot
.7431 .48838 Mdot
.74563 .4988 Mdot
.74809 .50919 Mdot
.75048 .51955 Mdot
.7528 .52986 Mdot
.75505 .54013 Mdot
.75722 .55035 Mdot
.75932 .56051 Mdot
.76134 .57062 Mdot
.76329 .58065 Mdot
.76516 .59062 Mdot
.76695 .60051 Mdot
.76867 .61033 Mdot
.7703 .62007 Mdot
.77186 .62971 Mdot
.77333 .63928 Mdot
.77473 .64874 Mdot
.77604 .65811 Mdot
.77727 .66738 Mdot
.77842 .67655 Mdot
.77949 .68562 Mdot
.78047 .69457 Mdot
.78137 .70341 Mdot
.78219 .71214 Mdot
.78292 .72075 Mdot
.78357 .72924 Mdot
.78413 .7376 Mdot
.78461 .74585 Mdot
.785 .75396 Mdot
.78531 .76195 Mdot
.78553 .7698 Mdot
.78566 .77753 Mdot
.78571 .78512 Mdot
.78568 .79257 Mdot
.78556 .79988 Mdot
.78535 .80706 Mdot
.78506 .81409 Mdot
.78468 .82099 Mdot
.78421 .82774 Mdot
.78367 .83434 Mdot
.78303 .8408 Mdot
.78231 .84711 Mdot
.78151 .85328 Mdot
.78062 .8593 Mdot
.77965 .86517 Mdot
.7786 .87089 Mdot
.77746 .87646 Mdot
.77624 .88187 Mdot
.77494 .88714 Mdot
.77356 .89226 Mdot
.7721 .89722 Mdot
.77055 .90203 Mdot
.76893 .90669 Mdot
.76723 .9112 Mdot
.76545 .91556 Mdot
.76359 .91976 Mdot
.76166 .92381 Mdot
.75965 .9277 Mdot
.75756 .93144 Mdot
.7554 .93503 Mdot
.75316 .93847 Mdot
.75086 .94176 Mdot
.74848 .94489 Mdot
.74603 .94787 Mdot
.74351 .9507 Mdot
.74092 .95338 Mdot
.73827 .95591 Mdot
.73554 .95828 Mdot
.73275 .96051 Mdot
.7299 .96258 Mdot
.72699 .96451 Mdot
.72401 .96629 Mdot
.72097 .96792 Mdot
.71787 .9694 Mdot
.71471 .97073 Mdot
.7115 .97192 Mdot
.70822 .97296 Mdot
.7049 .97385 Mdot
.70152 .9746 Mdot
.69809 .9752 Mdot
.69461 .97566 Mdot
.69107 .97598 Mdot
.68749 .97615 Mdot
.68387 .97619 Mdot
.6802 .97608 Mdot
.67648 .97582 Mdot
.67273 .97543 Mdot
.66893 .9749 Mdot
.6651 .97424 Mdot
.66122 .97343 Mdot
.65731 .97248 Mdot
.65337 .9714 Mdot
.64939 .97019 Mdot
.64539 .96884 Mdot
.64135 .96735 Mdot
.63729 .96573 Mdot
.63319 .96398 Mdot
.62908 .96209 Mdot
.62494 .96008 Mdot
.62078 .95793 Mdot
.6166 .95565 Mdot
.6124 .95325 Mdot
.60819 .95071 Mdot
.60396 .94805 Mdot
.59971 .94526 Mdot
.59546 .94235 Mdot
.5912 .93931 Mdot
.58693 .93615 Mdot
.58265 .93286 Mdot
.57837 .92945 Mdot
.57408 .92592 Mdot
.5698 .92226 Mdot
.56551 .91849 Mdot
.56123 .9146 Mdot
.55695 .91059 Mdot
.55268 .90646 Mdot
.54841 .90221 Mdot
.54416 .89785 Mdot
.53991 .89337 Mdot
.53568 .88878 Mdot
.53146 .88408 Mdot
.52726 .87926 Mdot
.52307 .87433 Mdot
.51891 .86929 Mdot
.51477 .86415 Mdot
.51064 .85889 Mdot
.50655 .85352 Mdot
.50248 .84805 Mdot
.49843 .84247 Mdot
.49442 .83679 Mdot
.49043 .83101 Mdot
.48648 .82512 Mdot
.48256 .81913 Mdot
.47868 .81304 Mdot
.47484 .80685 Mdot
.47103 .80056 Mdot
.46727 .79417 Mdot
.46354 .78769 Mdot
.45986 .78111 Mdot
.45622 .77444 Mdot
.45263 .76768 Mdot
.44909 .76083 Mdot
.4456 .75388 Mdot
.44215 .74685 Mdot
.43876 .73973 Mdot
.43542 .73253 Mdot
.43214 .72524 Mdot
.42891 .71786 Mdot
.42574 .71041 Mdot
.42262 .70287 Mdot
.41957 .69526 Mdot
.41658 .68757 Mdot
.41365 .6798 Mdot
.41078 .67197 Mdot
.40797 .66405 Mdot
.40524 .65607 Mdot
.40256 .64802 Mdot
.39996 .63991 Mdot
.39742 .63173 Mdot
.39496 .62348 Mdot
.39256 .61518 Mdot
.39024 .60681 Mdot
.38799 .59839 Mdot
.38581 .58992 Mdot
.3837 .58139 Mdot
.38167 .57281 Mdot
.37972 .56418 Mdot
.37784 .55551 Mdot
.37605 .54679 Mdot
.37433 .53804 Mdot
.37268 .52924 Mdot
.37112 .52041 Mdot
.36964 .51154 Mdot
.36824 .50265 Mdot
.36692 .49372 Mdot
.36568 .48477 Mdot
.36452 .4758 Mdot
.36345 .46681 Mdot
.36246 .45781 Mdot
.36155 .44879 Mdot
.36073 .43976 Mdot
.35999 .43072 Mdot
.35934 .42168 Mdot
.35877 .41263 Mdot
.35828 .4036 Mdot
.35788 .39456 Mdot
.35757 .38554 Mdot
.35734 .37653 Mdot
.3572 .36754 Mdot
.35714 .35857 Mdot
.35717 .34962 Mdot
.35729 .34071 Mdot
.35749 .33182 Mdot
.35777 .32297 Mdot
.35815 .31416 Mdot
.3586 .3054 Mdot
.35915 .29669 Mdot
.35977 .28803 Mdot
.36048 .27942 Mdot
.36128 .27088 Mdot
.36216 .2624 Mdot
.36312 .254 Mdot
.36417 .24567 Mdot
.3653 .23742 Mdot
.36651 .22925 Mdot
.36781 .22117 Mdot
.36918 .21319 Mdot
.37064 .2053 Mdot
.37218 .19752 Mdot
.37379 .18984 Mdot
.37549 .18228 Mdot
.37726 .17484 Mdot
.37912 .16751 Mdot
.38104 .16032 Mdot
.38305 .15325 Mdot
.38513 .14633 Mdot
.38728 .13954 Mdot
.38951 .1329 Mdot
.39181 .12641 Mdot
.39419 .12008 Mdot
.39663 .11391 Mdot
.39914 .10791 Mdot
.40173 .10207 Mdot
.40438 .09641 Mdot
.40709 .09093 Mdot
.40988 .08564 Mdot
.41273 .08053 Mdot
.41564 .07562 Mdot
.41861 .0709 Mdot
.42165 .06639 Mdot
.42474 .06208 Mdot
.42789 .05798 Mdot
.4311 .0541 Mdot
.43437 .05043 Mdot
.43769 .04699 Mdot
.44107 .04377 Mdot
.44449 .04078 Mdot
.44797 .03802 Mdot
.4515 .0355 Mdot
.45508 .03322 Mdot
.4587 .03117 Mdot
.46236 .02938 Mdot
.46608 .02783 Mdot
.46983 .02653 Mdot
.47362 .02548 Mdot
.47745 .02468 Mdot
.48132 .02414 Mdot
.48523 .02386 Mdot
.48917 .02383 Mdot
.49314 .02407 Mdot
.49715 .02456 Mdot
.50118 .02532 Mdot
.50525 .02634 Mdot
.50934 .02762 Mdot
.51345 .02916 Mdot
.51759 .03097 Mdot
.52175 .03304 Mdot
.52592 .03537 Mdot
.53012 .03796 Mdot
.53433 .04081 Mdot
.53856 .04392 Mdot
.5428 .04729 Mdot
.54706 .05091 Mdot
.55132 .05479 Mdot
.55559 .05892 Mdot
.55987 .0633 Mdot
.56415 .06792 Mdot
.56843 .07279 Mdot
.57272 .07789 Mdot
.577 .08324 Mdot
.58129 .08882 Mdot
.58557 .09462 Mdot
.58984 .10066 Mdot
.5941 .10691 Mdot
.59836 .11339 Mdot
.60261 .12007 Mdot
.60684 .12697 Mdot
.61106 .13407 Mdot
.61526 .14137 Mdot
.61945 .14886 Mdot
.62362 .15654 Mdot
.62776 .16441 Mdot
.63189 .17245 Mdot
.63599 .18066 Mdot
.64006 .18904 Mdot
.6441 .19758 Mdot
.64812 .20628 Mdot
.65211 .21512 Mdot
.65606 .2241 Mdot
.65998 .23322 Mdot
.66387 .24247 Mdot
.66771 .25185 Mdot
.67152 .26134 Mdot
.67529 .27094 Mdot
.67902 .28064 Mdot
.6827 .29044 Mdot
.68634 .30034 Mdot
.68994 .31032 Mdot
.69349 .32037 Mdot
.69698 .3305 Mdot
.70043 .34069 Mdot
.70383 .35094 Mdot
.70717 .36124 Mdot
.71046 .37159 Mdot
.71369 .38198 Mdot
.71687 .39241 Mdot
.71999 .40285 Mdot
.72305 .41333 Mdot
.72604 .42381 Mdot
.72898 .43431 Mdot
.73185 .4448 Mdot
.73466 .4553 Mdot
.73741 .46579 Mdot
.74008 .47626 Mdot
.74269 .48671 Mdot
.74523 .49714 Mdot
.74771 .50754 Mdot
.75011 .5179 Mdot
.75244 .52822 Mdot
.75469 .5385 Mdot
.75688 .54873 Mdot
.75899 .5589 Mdot
.76102 .56901 Mdot
.76298 .57906 Mdot
.76487 .58904 Mdot
.76667 .59894 Mdot
.7684 .60877 Mdot
.77005 .61852 Mdot
.77161 .62818 Mdot
.7731 .63776 Mdot
.77451 .64724 Mdot
.77584 .65663 Mdot
.77708 .66591 Mdot
.77825 .6751 Mdot
.77933 .68418 Mdot
.78032 .69315 Mdot
.78124 .70201 Mdot
.78207 .71075 Mdot
.78281 .71938 Mdot
.78347 .72789 Mdot
.78405 .73628 Mdot
.78454 .74454 Mdot
.78494 .75268 Mdot
.78526 .76068 Mdot
.7855 .76856 Mdot
.78565 .77631 Mdot
.78571 .78392 Mdot
.78569 .79139 Mdot
.78558 .79873 Mdot
.78539 .80592 Mdot
.78511 .81298 Mdot
.78474 .8199 Mdot
.78429 .82667 Mdot
.78376 .8333 Mdot
.78314 .83978 Mdot
.78243 .84612 Mdot
.78164 .85231 Mdot
.78077 .85835 Mdot
.77981 .86424 Mdot
.77877 .86998 Mdot
.77765 .87558 Mdot
.77644 .88102 Mdot
.77516 .88631 Mdot
.77379 .89145 Mdot
.77234 .89644 Mdot
.77081 .90128 Mdot
.7692 .90596 Mdot
.76751 .91049 Mdot
.76574 .91487 Mdot
.76389 .9191 Mdot
.76197 .92317 Mdot
.75997 .92709 Mdot
.7579 .93086 Mdot
.75575 .93447 Mdot
.75353 .93793 Mdot
.75123 .94124 Mdot
.74886 .9444 Mdot
.74642 .94741 Mdot
.74392 .95026 Mdot
.74134 .95296 Mdot
.73869 .95551 Mdot
.73598 .95791 Mdot
.7332 .96016 Mdot
.73036 .96226 Mdot
.72745 .96421 Mdot
.72449 .96601 Mdot
.72146 .96767 Mdot
.71837 .96917 Mdot
.71522 .97053 Mdot
.71201 .97174 Mdot
.70875 .9728 Mdot
.70543 .97372 Mdot
.70206 .97449 Mdot
.69864 .97512 Mdot
.69516 .9756 Mdot
.69164 .97594 Mdot
.68807 .97614 Mdot
.68445 .97619 Mdot
.68079 .9761 Mdot
.67708 .97587 Mdot
.67333 .97551 Mdot
.66954 .975 Mdot
.66571 .97435 Mdot
.66184 .97357 Mdot
.65794 .97264 Mdot
.654 .97159 Mdot
.65003 .97039 Mdot
.64603 .96906 Mdot
.642 .9676 Mdot
.63793 .966 Mdot
.63385 .96427 Mdot
.62974 .9624 Mdot
.6256 .96041 Mdot
.62144 .95828 Mdot
.61727 .95602 Mdot
.61307 .95364 Mdot
.60886 .95113 Mdot
.60463 .94848 Mdot
.60039 .94572 Mdot
.59614 .94282 Mdot
.59188 .9398 Mdot
.58761 .93666 Mdot
.58333 .93339 Mdot
.57905 .93 Mdot
.57477 .92649 Mdot
.57048 .92285 Mdot
.5662 .9191 Mdot
.56191 .91523 Mdot
.55763 .91123 Mdot
.55336 .90712 Mdot
.54909 .9029 Mdot
.54483 .89855 Mdot
.54059 .8941 Mdot
.53635 .88952 Mdot
.53213 .88484 Mdot
.52793 .88004 Mdot
.52374 .87513 Mdot
.51957 .8701 Mdot
.51542 .86497 Mdot
.5113 .85973 Mdot
.5072 .85439 Mdot
.50312 .84893 Mdot
.49907 .84337 Mdot
.49505 .8377 Mdot
.49107 .83193 Mdot
.48711 .82606 Mdot
.48319 .82009 Mdot
.4793 .81401 Mdot
.47545 .80784 Mdot
.47164 .80157 Mdot
.46786 .7952 Mdot
.46413 .78873 Mdot
.46044 .78217 Mdot
.4568 .77551 Mdot
.4532 .76876 Mdot
.44965 .76192 Mdot
.44615 .75499 Mdot
.4427 .74798 Mdot
.4393 .74087 Mdot
.43595 .73368 Mdot
.43266 .7264 Mdot
.42942 .71904 Mdot
.42624 .7116 Mdot
.42312 .70408 Mdot
.42005 .69648 Mdot
.41705 .6888 Mdot
.41411 .68105 Mdot
.41123 .67322 Mdot
.40842 .66532 Mdot
.40567 .65735 Mdot
.40298 .64931 Mdot
.40037 .6412 Mdot
.39782 .63303 Mdot
.39535 .6248 Mdot
.39294 .6165 Mdot
.3906 .60815 Mdot
.38834 .59974 Mdot
.38615 .59127 Mdot
.38403 .58275 Mdot
.38199 .57418 Mdot
.38003 .56556 Mdot
.37814 .55689 Mdot
.37633 .54818 Mdot
.37459 .53943 Mdot
.37294 .53064 Mdot
.37136 .52182 Mdot
.36987 .51296 Mdot
.36845 .50407 Mdot
.36712 .49515 Mdot
.36587 .4862 Mdot
.3647 .47723 Mdot
.36361 .46825 Mdot
.36261 .45924 Mdot
.36169 .45022 Mdot
.36085 .44119 Mdot
.3601 .43216 Mdot
.35943 .42312 Mdot
.35885 .41407 Mdot
.35835 .40503 Mdot
.35794 .396 Mdot
.35761 .38698 Mdot
.35737 .37797 Mdot
.35722 .36897 Mdot
.35715 .36 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
ComparisonPlot[7/20, 4/5];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147052 0.588614 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01471 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13243 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25015 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36787 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13243 m
1 .13243 L
s
P
p
0 0 .5 r
.001 w
0 .25015 m
1 .25015 L
s
P
p
0 0 .5 r
.001 w
0 .36787 m
1 .36787 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01471 m
.00625 .01471 L
s
P
[(0)] -0.0125 .01471 1 0 0 Minner Mrotshowa
p
.002 w
0 .13243 m
.00625 .13243 L
s
P
[(0.2)] -0.0125 .13243 1 0 0 Minner Mrotshowa
p
.002 w
0 .25015 m
.00625 .25015 L
s
P
[(0.4)] -0.0125 .25015 1 0 0 Minner Mrotshowa
p
.002 w
0 .36787 m
.00625 .36787 L
s
P
[(0.6)] -0.0125 .36787 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03825 m
.00375 .03825 L
s
P
p
.001 w
0 .06179 m
.00375 .06179 L
s
P
p
.001 w
0 .08534 m
.00375 .08534 L
s
P
p
.001 w
0 .10888 m
.00375 .10888 L
s
P
p
.001 w
0 .15597 m
.00375 .15597 L
s
P
p
.001 w
0 .17952 m
.00375 .17952 L
s
P
p
.001 w
0 .20306 m
.00375 .20306 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29724 m
.00375 .29724 L
s
P
p
.001 w
0 .32078 m
.00375 .32078 L
s
P
p
.001 w
0 .34433 m
.00375 .34433 L
s
P
p
.001 w
0 .39142 m
.00375 .39142 L
s
P
p
.001 w
0 .41496 m
.00375 .41496 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46205 m
.00375 .46205 L
s
P
p
.001 w
0 .50914 m
.00375 .50914 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01471 m
1 .01471 L
s
P
p
.002 w
.99375 .13243 m
1 .13243 L
s
P
p
.002 w
.99375 .25015 m
1 .25015 L
s
P
p
.002 w
.99375 .36787 m
1 .36787 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03825 m
1 .03825 L
s
P
p
.001 w
.99625 .06179 m
1 .06179 L
s
P
p
.001 w
.99625 .08534 m
1 .08534 L
s
P
p
.001 w
.99625 .10888 m
1 .10888 L
s
P
p
.001 w
.99625 .15597 m
1 .15597 L
s
P
p
.001 w
.99625 .17952 m
1 .17952 L
s
P
p
.001 w
.99625 .20306 m
1 .20306 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29724 m
1 .29724 L
s
P
p
.001 w
.99625 .32078 m
1 .32078 L
s
P
p
.001 w
.99625 .34433 m
1 .34433 L
s
P
p
.001 w
.99625 .39142 m
1 .39142 L
s
P
p
.001 w
.99625 .41496 m
1 .41496 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46205 m
1 .46205 L
s
P
p
.001 w
.99625 .50914 m
1 .50914 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .22072 m
.04365 .15055 L
.06349 .08899 L
.07341 .06349 L
.08333 .0426 L
.08829 .03413 L
.09325 .02709 L
.09821 .02157 L
.10069 .0194 L
.10317 .01763 L
.10565 .01627 L
.10689 .01575 L
.10813 .01533 L
.10938 .01502 L
.11062 .01481 L
.11186 .01472 L
.1131 .01472 L
.11434 .01484 L
.11558 .01506 L
.11682 .01539 L
.11806 .01583 L
.12054 .01704 L
.12302 .01867 L
.12798 .02325 L
.13294 .02955 L
.14286 .04717 L
.15278 .07107 L
.1627 .10057 L
.18254 .17271 L
.22222 .3395 L
.24206 .41807 L
.2619 .4856 L
.27183 .51413 L
.28175 .53883 L
.29167 .55955 L
.30159 .57625 L
.31151 .5889 L
.31647 .59373 L
.32143 .59756 L
.32639 .60041 L
.32887 .60147 L
.33135 .60229 L
.33259 .60261 L
.33383 .60287 L
.33507 .60307 L
.33631 .60321 L
.33755 .6033 L
.33879 .60332 L
.34003 .60328 L
.34127 .60319 L
Mistroke
.34251 .60304 L
.34375 .60283 L
.34623 .60224 L
.34871 .60142 L
.35119 .60037 L
.35615 .59761 L
.36111 .59396 L
.37103 .58407 L
.38095 .57086 L
.40079 .535 L
.42063 .48763 L
.46032 .36469 L
.5 .22072 L
.51984 .15055 L
.53968 .08899 L
.5496 .06349 L
.55952 .0426 L
.56448 .03413 L
.56944 .02709 L
.5744 .02157 L
.57688 .0194 L
.57937 .01763 L
.58061 .0169 L
.58185 .01627 L
.58309 .01575 L
.58433 .01533 L
.58557 .01502 L
.58681 .01481 L
.58805 .01472 L
.58929 .01472 L
.59053 .01484 L
.59177 .01506 L
.59301 .01539 L
.59425 .01583 L
.59673 .01704 L
.59921 .01867 L
.60417 .02325 L
.60913 .02955 L
.61905 .04717 L
.62897 .07107 L
.63889 .10057 L
.65873 .17271 L
.69841 .3395 L
.71825 .41807 L
.7381 .4856 L
.74802 .51413 L
.75794 .53883 L
.76786 .55955 L
.77778 .57625 L
.78274 .58308 L
Mistroke
.7877 .5889 L
.79266 .59373 L
.79762 .59756 L
.8001 .59911 L
.80258 .60041 L
.80506 .60147 L
.80754 .60229 L
.80878 .60261 L
.81002 .60287 L
.81126 .60307 L
.8125 .60321 L
.81374 .6033 L
.81498 .60332 L
.81622 .60328 L
.81746 .60319 L
.8187 .60304 L
.81994 .60283 L
.82242 .60224 L
.8249 .60142 L
.82738 .60037 L
.83234 .59761 L
.8373 .59396 L
.84722 .58407 L
.85714 .57086 L
.87698 .535 L
.89683 .48763 L
.93651 .36469 L
.97619 .22072 L
Mfstroke
P
P
p
p
.02 w
.02381 .22072 m
.02505 .22074 L
.02629 .22079 L
.02753 .22088 L
.02877 .221 L
.03001 .22116 L
.03125 .22136 L
.03373 .22185 L
.03621 .22249 L
.03869 .22326 L
.04365 .22523 L
.05357 .2308 L
.06349 .23846 L
.08333 .25951 L
.10317 .28694 L
.14286 .35316 L
.18254 .41938 L
.20238 .44681 L
.2123 .45823 L
.22222 .46785 L
.23214 .47552 L
.2371 .47857 L
.24206 .48108 L
.24702 .48305 L
.2495 .48383 L
.25198 .48446 L
.25446 .48496 L
.2557 .48515 L
.25694 .48531 L
.25818 .48544 L
.25942 .48553 L
.26066 .48558 L
.2619 .4856 L
.26314 .48558 L
.26438 .48553 L
.26562 .48544 L
.26687 .48531 L
.26935 .48496 L
.27183 .48446 L
.27431 .48383 L
.27679 .48305 L
.28175 .48108 L
.29167 .47552 L
.30159 .46785 L
.32143 .44681 L
.34127 .41938 L
.38095 .35316 L
.42063 .28694 L
.44048 .25951 L
.4504 .24809 L
Mistroke
.46032 .23846 L
.47024 .2308 L
.48016 .22523 L
.48512 .22326 L
.4876 .22249 L
.49008 .22185 L
.49256 .22136 L
.4938 .22116 L
.49504 .221 L
.49628 .22088 L
.49752 .22079 L
.49876 .22074 L
.5 .22072 L
.50124 .22074 L
.50248 .22079 L
.50372 .22088 L
.50496 .221 L
.5062 .22116 L
.50744 .22136 L
.50992 .22185 L
.5124 .22249 L
.51488 .22326 L
.51984 .22523 L
.52976 .2308 L
.53968 .23846 L
.55952 .25951 L
.57937 .28694 L
.61905 .35316 L
.65873 .41938 L
.67857 .44681 L
.68849 .45823 L
.69841 .46785 L
.70833 .47552 L
.71329 .47857 L
.71825 .48108 L
.72321 .48305 L
.72569 .48383 L
.72817 .48446 L
.73065 .48496 L
.73189 .48515 L
.73313 .48531 L
.73437 .48544 L
.73562 .48553 L
.73686 .48558 L
.7381 .4856 L
.73934 .48558 L
.74058 .48553 L
.74182 .48544 L
.74306 .48531 L
.74554 .48496 L
Mistroke
.74802 .48446 L
.7505 .48383 L
.75298 .48305 L
.75794 .48108 L
.76786 .47552 L
.77778 .46785 L
.79762 .44681 L
.81746 .41938 L
.85714 .35316 L
.89683 .28694 L
.91667 .25951 L
.93651 .23846 L
.94643 .2308 L
.95139 .22775 L
.95635 .22523 L
.96131 .22326 L
.96379 .22249 L
.96627 .22185 L
.96875 .22136 L
.96999 .22116 L
.97123 .221 L
.97247 .22088 L
.97371 .22079 L
.97495 .22074 L
.97619 .22072 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!  p0A=1/2, p0B=1/2
:[font = text; inactive; preserveAspect]
When p0A=p0B classically it does not matter which Method you use. Quantum mechanically, the choice of Method does matter a great deal.
:[font = input; preserveAspect; startGroup]
ComparisonPlot[1/2, 1/2];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147151 0.588604 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13244 m
1 .13244 L
s
P
p
0 0 .5 r
.001 w
0 .25016 m
1 .25016 L
s
P
p
0 0 .5 r
.001 w
0 .36788 m
1 .36788 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .13244 m
.00625 .13244 L
s
P
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotshowa
p
.002 w
0 .25016 m
.00625 .25016 L
s
P
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotshowa
p
.002 w
0 .36788 m
.00625 .36788 L
s
P
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .0618 m
.00375 .0618 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .10889 m
.00375 .10889 L
s
P
p
.001 w
0 .15598 m
.00375 .15598 L
s
P
p
.001 w
0 .17952 m
.00375 .17952 L
s
P
p
.001 w
0 .20307 m
.00375 .20307 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29724 m
.00375 .29724 L
s
P
p
.001 w
0 .32079 m
.00375 .32079 L
s
P
p
.001 w
0 .34433 m
.00375 .34433 L
s
P
p
.001 w
0 .39142 m
.00375 .39142 L
s
P
p
.001 w
0 .41497 m
.00375 .41497 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46205 m
.00375 .46205 L
s
P
p
.001 w
0 .50914 m
.00375 .50914 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .13244 m
1 .13244 L
s
P
p
.002 w
.99375 .25016 m
1 .25016 L
s
P
p
.002 w
.99375 .36788 m
1 .36788 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .0618 m
1 .0618 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .10889 m
1 .10889 L
s
P
p
.001 w
.99625 .15598 m
1 .15598 L
s
P
p
.001 w
.99625 .17952 m
1 .17952 L
s
P
p
.001 w
.99625 .20307 m
1 .20307 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29724 m
1 .29724 L
s
P
p
.001 w
.99625 .32079 m
1 .32079 L
s
P
p
.001 w
.99625 .34433 m
1 .34433 L
s
P
p
.001 w
.99625 .39142 m
1 .39142 L
s
P
p
.001 w
.99625 .41497 m
1 .41497 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46205 m
1 .46205 L
s
P
p
.001 w
.99625 .50914 m
1 .50914 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .30902 m
.06349 .16187 L
.08333 .10091 L
.09325 .07553 L
.10317 .05414 L
.1131 .03712 L
.12302 .02474 L
.12798 .02037 L
.13046 .01865 L
.13294 .01723 L
.13542 .01613 L
.13666 .0157 L
.1379 .01535 L
.13914 .01507 L
.14038 .01487 L
.14162 .01475 L
.14286 .01472 L
.1441 .01475 L
.14534 .01487 L
.14658 .01507 L
.14782 .01535 L
.1503 .01613 L
.15278 .01723 L
.15526 .01865 L
.15774 .02037 L
.1627 .02474 L
.17262 .03712 L
.18254 .05414 L
.20238 .10091 L
.22222 .16187 L
.2619 .30902 L
.30159 .45617 L
.32143 .51712 L
.34127 .56389 L
.35119 .58092 L
.35615 .5877 L
.36111 .59329 L
.36607 .59766 L
.36855 .59939 L
.37103 .6008 L
.37351 .6019 L
.37475 .60233 L
.37599 .60269 L
.37723 .60296 L
.37847 .60316 L
.37971 .60328 L
.38095 .60332 L
.38219 .60328 L
.38343 .60316 L
.38467 .60296 L
Mistroke
.38591 .60269 L
.38839 .6019 L
.39087 .6008 L
.39335 .59939 L
.39583 .59766 L
.40079 .59329 L
.41071 .58092 L
.42063 .56389 L
.44048 .51712 L
.46032 .45617 L
.5 .30902 L
.53968 .16187 L
.55952 .10091 L
.56944 .07553 L
.57937 .05414 L
.58929 .03712 L
.59425 .03033 L
.59921 .02474 L
.60417 .02037 L
.60665 .01865 L
.60913 .01723 L
.61161 .01613 L
.61285 .0157 L
.61409 .01535 L
.61533 .01507 L
.61657 .01487 L
.61781 .01475 L
.61905 .01472 L
.62029 .01475 L
.62153 .01487 L
.62277 .01507 L
.62401 .01535 L
.62649 .01613 L
.62897 .01723 L
.63145 .01865 L
.63393 .02037 L
.63889 .02474 L
.64881 .03712 L
.65873 .05414 L
.67857 .10091 L
.69841 .16187 L
.7381 .30902 L
.77778 .45617 L
.79762 .51712 L
.80754 .5425 L
.81746 .56389 L
.82738 .58092 L
.83234 .5877 L
.8373 .59329 L
.84226 .59766 L
Mistroke
.84474 .59939 L
.84722 .6008 L
.8497 .6019 L
.85094 .60233 L
.85218 .60269 L
.85342 .60296 L
.85466 .60316 L
.8559 .60328 L
.85714 .60332 L
.85838 .60328 L
.85962 .60316 L
.86086 .60296 L
.8621 .60269 L
.86458 .6019 L
.86706 .6008 L
.86954 .59939 L
.87202 .59766 L
.87698 .59329 L
.8869 .58092 L
.89683 .56389 L
.91667 .51712 L
.93651 .45617 L
.97619 .30902 L
Mfstroke
P
P
p
p
.02 w
.02381 .30902 m
.06349 .30902 L
.10317 .30902 L
.12302 .30902 L
.14286 .30902 L
.15278 .30902 L
.1627 .30902 L
.16766 .30902 L
.17262 .30902 L
.1751 .30902 L
.17758 .30902 L
.17882 .30902 L
.18006 .30902 L
.1813 .30902 L
.18254 .30902 L
.18378 .30902 L
.18502 .30902 L
.18626 .30902 L
.1875 .30902 L
.19246 .30902 L
.20238 .30902 L
.22222 .30902 L
.24206 .30902 L
.25198 .30902 L
.25694 .30902 L
.2619 .30902 L
.26687 .30902 L
.26811 .30902 L
.26935 .30902 L
.27059 .30902 L
.27183 .30902 L
.27307 .30902 L
.27431 .30902 L
.27555 .30902 L
.27679 .30902 L
.27803 .30902 L
.27927 .30902 L
.28051 .30902 L
.28175 .30902 L
.28299 .30902 L
.28423 .30902 L
.28547 .30902 L
.28671 .30902 L
.28795 .30902 L
.28919 .30902 L
.29043 .30902 L
.29167 .30902 L
.29291 .30902 L
.29415 .30902 L
.29663 .30902 L
Mistroke
.29911 .30902 L
.30035 .30902 L
.30159 .30902 L
.30283 .30902 L
.30407 .30902 L
.30655 .30902 L
.31151 .30902 L
.31647 .30902 L
.32143 .30902 L
.34127 .30902 L
.38095 .30902 L
.40079 .30902 L
.42063 .30902 L
.43056 .30902 L
.44048 .30902 L
.44544 .30902 L
.4504 .30902 L
.45536 .30902 L
.4566 .30902 L
.45784 .30902 L
.45908 .30902 L
.46032 .30902 L
.46156 .30902 L
.4628 .30902 L
.46528 .30902 L
.46776 .30902 L
.469 .30902 L
.47024 .30902 L
.47148 .30902 L
.47272 .30902 L
.4752 .30902 L
.47644 .30902 L
.47768 .30902 L
.47892 .30902 L
.48016 .30902 L
.4814 .30902 L
.48264 .30902 L
.48388 .30902 L
.48512 .30902 L
.4876 .30902 L
.49008 .30902 L
.5 .30902 L
.53968 .30902 L
.57937 .30902 L
.59921 .30902 L
.60913 .30902 L
.61409 .30902 L
.61905 .30902 L
.62029 .30902 L
.62153 .30902 L
Mistroke
.62277 .30902 L
.62401 .30902 L
.62649 .30902 L
.62773 .30902 L
.62897 .30902 L
.63889 .30902 L
.64013 .30902 L
.64137 .30902 L
.64261 .30902 L
.64385 .30902 L
.64881 .30902 L
.65129 .30902 L
.65377 .30902 L
.65625 .30902 L
.65749 .30902 L
.65873 .30902 L
.65997 .30902 L
.66121 .30902 L
.66245 .30902 L
.66369 .30902 L
.66493 .30902 L
.66617 .30902 L
.66741 .30902 L
.66865 .30902 L
.67361 .30902 L
.67485 .30902 L
.67609 .30902 L
.67733 .30902 L
.67857 .30902 L
.68105 .30902 L
.68353 .30902 L
.68849 .30902 L
.69097 .30902 L
.69345 .30902 L
.69469 .30902 L
.69593 .30902 L
.69717 .30902 L
.69841 .30902 L
.69965 .30902 L
.70089 .30902 L
.70337 .30902 L
.70833 .30902 L
.71329 .30902 L
.71453 .30902 L
.71577 .30902 L
.71701 .30902 L
.71825 .30902 L
.71949 .30902 L
.72073 .30902 L
.72197 .30902 L
Mistroke
.72321 .30902 L
.72817 .30902 L
.7381 .30902 L
.74306 .30902 L
.74802 .30902 L
.75298 .30902 L
.75422 .30902 L
.75546 .30902 L
.7567 .30902 L
.75794 .30902 L
.75918 .30902 L
.76042 .30902 L
.76166 .30902 L
.7629 .30902 L
.76786 .30902 L
.77034 .30902 L
.77282 .30902 L
.7753 .30902 L
.77654 .30902 L
.77778 .30902 L
.77902 .30902 L
.78026 .30902 L
.78274 .30902 L
.7877 .30902 L
.79266 .30902 L
.79514 .30902 L
.79638 .30902 L
.79762 .30902 L
.79886 .30902 L
.8001 .30902 L
.80134 .30902 L
.80258 .30902 L
.80754 .30902 L
.81746 .30902 L
.8187 .30902 L
.81994 .30902 L
.82242 .30902 L
.82738 .30902 L
.83234 .30902 L
.83358 .30902 L
.83482 .30902 L
.83606 .30902 L
.8373 .30902 L
.83854 .30902 L
.83978 .30902 L
.84102 .30902 L
.84226 .30902 L
.84722 .30902 L
.85714 .30902 L
.87698 .30902 L
Mistroke
.87946 .30902 L
.88194 .30902 L
.88318 .30902 L
.88442 .30902 L
.88566 .30902 L
.8869 .30902 L
.88814 .30902 L
.88938 .30902 L
.89187 .30902 L
.89683 .30902 L
.90179 .30902 L
.90675 .30902 L
.91171 .30902 L
.91295 .30902 L
.91419 .30902 L
.91543 .30902 L
.91667 .30902 L
.91791 .30902 L
.91915 .30902 L
.92039 .30902 L
.92163 .30902 L
.92287 .30902 L
.92411 .30902 L
.92659 .30902 L
.92783 .30902 L
.92907 .30902 L
.93031 .30902 L
.93155 .30902 L
.93403 .30902 L
.93527 .30902 L
.93651 .30902 L
.93775 .30902 L
.93899 .30902 L
.94147 .30902 L
.94643 .30902 L
.94767 .30902 L
.94891 .30902 L
.95015 .30902 L
.95139 .30902 L
.95387 .30902 L
.95511 .30902 L
.95635 .30902 L
.95759 .30902 L
.95883 .30902 L
.96131 .30902 L
.96627 .30902 L
.97619 .30902 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me! (p0A=0.9, p0B=0.2)
:[font = text; inactive; preserveAspect]
Sometimes, classical and quantum probabilities can be close ...
:[font = input; preserveAspect; startGroup]
ComparisonPlot[0.9, 0.2];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0147139 0.588612 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01471 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60333 1 0 0 Minner Mrotsboxa
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13244 m
1 .13244 L
s
P
p
0 0 .5 r
.001 w
0 .25016 m
1 .25016 L
s
P
p
0 0 .5 r
.001 w
0 .36788 m
1 .36788 L
s
P
p
0 0 .5 r
.001 w
0 .4856 m
1 .4856 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01471 m
.00625 .01471 L
s
P
[(0)] -0.0125 .01471 1 0 0 Minner Mrotshowa
p
.002 w
0 .13244 m
.00625 .13244 L
s
P
[(0.2)] -0.0125 .13244 1 0 0 Minner Mrotshowa
p
.002 w
0 .25016 m
.00625 .25016 L
s
P
[(0.4)] -0.0125 .25016 1 0 0 Minner Mrotshowa
p
.002 w
0 .36788 m
.00625 .36788 L
s
P
[(0.6)] -0.0125 .36788 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(0.8)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60333 m
.00625 .60333 L
s
P
[(1)] -0.0125 .60333 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .0618 m
.00375 .0618 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .10889 m
.00375 .10889 L
s
P
p
.001 w
0 .15598 m
.00375 .15598 L
s
P
p
.001 w
0 .17953 m
.00375 .17953 L
s
P
p
.001 w
0 .20307 m
.00375 .20307 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29725 m
.00375 .29725 L
s
P
p
.001 w
0 .32079 m
.00375 .32079 L
s
P
p
.001 w
0 .34434 m
.00375 .34434 L
s
P
p
.001 w
0 .39143 m
.00375 .39143 L
s
P
p
.001 w
0 .41497 m
.00375 .41497 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46206 m
.00375 .46206 L
s
P
p
.001 w
0 .50915 m
.00375 .50915 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55624 m
.00375 .55624 L
s
P
p
.001 w
0 .57978 m
.00375 .57978 L
s
P
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01471 m
1 .01471 L
s
P
p
.002 w
.99375 .13244 m
1 .13244 L
s
P
p
.002 w
.99375 .25016 m
1 .25016 L
s
P
p
.002 w
.99375 .36788 m
1 .36788 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60333 m
1 .60333 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .0618 m
1 .0618 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .10889 m
1 .10889 L
s
P
p
.001 w
.99625 .15598 m
1 .15598 L
s
P
p
.001 w
.99625 .17953 m
1 .17953 L
s
P
p
.001 w
.99625 .20307 m
1 .20307 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29725 m
1 .29725 L
s
P
p
.001 w
.99625 .32079 m
1 .32079 L
s
P
p
.001 w
.99625 .34434 m
1 .34434 L
s
P
p
.001 w
.99625 .39143 m
1 .39143 L
s
P
p
.001 w
.99625 .41497 m
1 .41497 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46206 m
1 .46206 L
s
P
p
.001 w
.99625 .50915 m
1 .50915 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55624 m
1 .55624 L
s
P
p
.001 w
.99625 .57978 m
1 .57978 L
s
P
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .54446 m
.06349 .42071 L
.10317 .25456 L
.12302 .17205 L
.14286 .10091 L
.15278 .072 L
.1627 .04853 L
.16766 .03901 L
.17262 .03103 L
.17758 .02462 L
.18006 .02201 L
.18254 .0198 L
.18502 .01799 L
.1875 .01657 L
.18874 .01602 L
.18998 .01556 L
.19122 .0152 L
.19246 .01494 L
.1937 .01478 L
.19494 .01472 L
.19618 .01475 L
.19742 .01488 L
.19866 .01511 L
.1999 .01543 L
.20114 .01585 L
.20238 .01636 L
.20486 .01766 L
.20734 .01934 L
.2123 .02376 L
.21726 .02958 L
.22222 .03673 L
.24206 .07711 L
.2619 .13244 L
.30159 .26706 L
.34127 .40403 L
.36111 .46486 L
.38095 .51713 L
.40079 .55868 L
.41071 .57482 L
.42063 .58757 L
.4256 .59259 L
.43056 .59669 L
.43304 .59838 L
.43552 .59983 L
.438 .60103 L
.44048 .60198 L
.44172 .60236 L
.44296 .60268 L
.4442 .60294 L
.44544 .60313 L
Mistroke
.44668 .60326 L
.44792 .60332 L
.44916 .60332 L
.4504 .60325 L
.45164 .60312 L
.45288 .60292 L
.45536 .60232 L
.4566 .60192 L
.45784 .60145 L
.46032 .60032 L
.46528 .59723 L
.47024 .59305 L
.48016 .58134 L
.49008 .56514 L
.5 .54446 L
.51984 .49022 L
.53968 .42071 L
.57937 .25456 L
.59921 .17205 L
.61905 .10091 L
.62897 .072 L
.63889 .04853 L
.64881 .03103 L
.65377 .02462 L
.65625 .02201 L
.65873 .0198 L
.66121 .01799 L
.66369 .01657 L
.66617 .01556 L
.66741 .0152 L
.66865 .01494 L
.66989 .01478 L
.67113 .01472 L
.67237 .01475 L
.67361 .01488 L
.67485 .01511 L
.67609 .01543 L
.67857 .01636 L
.68105 .01766 L
.68353 .01934 L
.68849 .02376 L
.69345 .02958 L
.69841 .03673 L
.71825 .07711 L
.7381 .13244 L
.77778 .26706 L
.81746 .40403 L
.8373 .46486 L
.85714 .51713 L
.86706 .53937 L
Mistroke
.87698 .55868 L
.8869 .57482 L
.89683 .58757 L
.90179 .59259 L
.90675 .59669 L
.91171 .59983 L
.91419 .60103 L
.91667 .60198 L
.91915 .60268 L
.92039 .60294 L
.92163 .60313 L
.92287 .60326 L
.92411 .60332 L
.92535 .60332 L
.92659 .60325 L
.92783 .60312 L
.92907 .60292 L
.93031 .60265 L
.93155 .60232 L
.93403 .60145 L
.93651 .60032 L
.94147 .59723 L
.94643 .59305 L
.95635 .58134 L
.96627 .56514 L
.97619 .54446 L
Mfstroke
P
P
p
p
.02 w
.02381 .54446 m
.02505 .54444 L
.02629 .54435 L
.02753 .54422 L
.02877 .54402 L
.03001 .54378 L
.03125 .54347 L
.03373 .5427 L
.03621 .54171 L
.03869 .54051 L
.04365 .53744 L
.05357 .52878 L
.06349 .51686 L
.08333 .48412 L
.10317 .44146 L
.14286 .33845 L
.18254 .23544 L
.20238 .19278 L
.2123 .17501 L
.22222 .16004 L
.23214 .14812 L
.2371 .14337 L
.24206 .13946 L
.24702 .13639 L
.2495 .13519 L
.25198 .1342 L
.25446 .13343 L
.2557 .13313 L
.25694 .13288 L
.25818 .13268 L
.25942 .13255 L
.26066 .13246 L
.2619 .13244 L
.26314 .13246 L
.26438 .13255 L
.26562 .13268 L
.26687 .13288 L
.26935 .13343 L
.27183 .1342 L
.27431 .13519 L
.27679 .13639 L
.28175 .13946 L
.29167 .14812 L
.30159 .16004 L
.32143 .19278 L
.34127 .23544 L
.38095 .33845 L
.42063 .44146 L
.44048 .48412 L
.4504 .50189 L
Mistroke
.46032 .51686 L
.47024 .52878 L
.48016 .53744 L
.48512 .54051 L
.4876 .54171 L
.49008 .5427 L
.49256 .54347 L
.4938 .54378 L
.49504 .54402 L
.49628 .54422 L
.49752 .54435 L
.49876 .54444 L
.5 .54446 L
.50124 .54444 L
.50248 .54435 L
.50372 .54422 L
.50496 .54402 L
.5062 .54378 L
.50744 .54347 L
.50992 .5427 L
.5124 .54171 L
.51488 .54051 L
.51984 .53744 L
.52976 .52878 L
.53968 .51686 L
.55952 .48412 L
.57937 .44146 L
.61905 .33845 L
.65873 .23544 L
.67857 .19278 L
.68849 .17501 L
.69841 .16004 L
.70833 .14812 L
.71329 .14337 L
.71825 .13946 L
.72321 .13639 L
.72569 .13519 L
.72817 .1342 L
.73065 .13343 L
.73189 .13313 L
.73313 .13288 L
.73437 .13268 L
.73562 .13255 L
.73686 .13246 L
.7381 .13244 L
.73934 .13246 L
.74058 .13255 L
.74182 .13268 L
.74306 .13288 L
.74554 .13343 L
Mistroke
.74802 .1342 L
.7505 .13519 L
.75298 .13639 L
.75794 .13946 L
.76786 .14812 L
.77778 .16004 L
.79762 .19278 L
.81746 .23544 L
.85714 .33845 L
.89683 .44146 L
.91667 .48412 L
.93651 .51686 L
.94643 .52878 L
.95139 .53353 L
.95635 .53744 L
.96131 .54051 L
.96379 .54171 L
.96627 .5427 L
.96875 .54347 L
.96999 .54378 L
.97123 .54402 L
.97247 .54422 L
.97371 .54435 L
.97495 .54444 L
.97619 .54446 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me! (p0A=1.0, p0B=0.9)
:[font = text; inactive; preserveAspect]
The quantum probability is not always the larger one as the interference effect may be destructive.
:[font = input; preserveAspect; startGroup]
ComparisonPlot[1,0.9];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 245; pictureHeight = 151; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.0146472 0.588672 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(1)] .17539 0 0 2 0 Minner Mrotsboxa
[(2)] .32696 0 0 2 0 Minner Mrotsboxa
[(3)] .47854 0 0 2 0 Minner Mrotsboxa
[(4)] .63011 0 0 2 0 Minner Mrotsboxa
[(5)] .78169 0 0 2 0 Minner Mrotsboxa
[(6)] .93327 0 0 2 0 Minner Mrotsboxa
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01465 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .13238 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .25012 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .36785 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .48558 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17539 0 m
.17539 .61803 L
s
P
p
0 0 .5 r
.001 w
.32696 0 m
.32696 .61803 L
s
P
p
0 0 .5 r
.001 w
.47854 0 m
.47854 .61803 L
s
P
p
0 0 .5 r
.001 w
.63011 0 m
.63011 .61803 L
s
P
p
0 0 .5 r
.001 w
.78169 0 m
.78169 .61803 L
s
P
p
0 0 .5 r
.001 w
.93327 0 m
.93327 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .13238 m
1 .13238 L
s
P
p
0 0 .5 r
.001 w
0 .25012 m
1 .25012 L
s
P
p
0 0 .5 r
.001 w
0 .36785 m
1 .36785 L
s
P
p
0 0 .5 r
.001 w
0 .48558 m
1 .48558 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.17539 0 m
.17539 .00625 L
s
P
[(1)] .17539 0 0 2 0 Minner Mrotshowa
p
.002 w
.32696 0 m
.32696 .00625 L
s
P
[(2)] .32696 0 0 2 0 Minner Mrotshowa
p
.002 w
.47854 0 m
.47854 .00625 L
s
P
[(3)] .47854 0 0 2 0 Minner Mrotshowa
p
.002 w
.63011 0 m
.63011 .00625 L
s
P
[(4)] .63011 0 0 2 0 Minner Mrotshowa
p
.002 w
.78169 0 m
.78169 .00625 L
s
P
[(5)] .78169 0 0 2 0 Minner Mrotshowa
p
.002 w
.93327 0 m
.93327 .00625 L
s
P
[(6)] .93327 0 0 2 0 Minner Mrotshowa
p
.001 w
.05412 0 m
.05412 .00375 L
s
P
p
.001 w
.08444 0 m
.08444 .00375 L
s
P
p
.001 w
.11476 0 m
.11476 .00375 L
s
P
p
.001 w
.14507 0 m
.14507 .00375 L
s
P
p
.001 w
.2057 0 m
.2057 .00375 L
s
P
p
.001 w
.23602 0 m
.23602 .00375 L
s
P
p
.001 w
.26633 0 m
.26633 .00375 L
s
P
p
.001 w
.29665 0 m
.29665 .00375 L
s
P
p
.001 w
.35728 0 m
.35728 .00375 L
s
P
p
.001 w
.38759 0 m
.38759 .00375 L
s
P
p
.001 w
.41791 0 m
.41791 .00375 L
s
P
p
.001 w
.44822 0 m
.44822 .00375 L
s
P
p
.001 w
.50885 0 m
.50885 .00375 L
s
P
p
.001 w
.53917 0 m
.53917 .00375 L
s
P
p
.001 w
.56948 0 m
.56948 .00375 L
s
P
p
.001 w
.5998 0 m
.5998 .00375 L
s
P
p
.001 w
.66043 0 m
.66043 .00375 L
s
P
p
.001 w
.69074 0 m
.69074 .00375 L
s
P
p
.001 w
.72106 0 m
.72106 .00375 L
s
P
p
.001 w
.75137 0 m
.75137 .00375 L
s
P
p
.001 w
.81201 0 m
.81201 .00375 L
s
P
p
.001 w
.84232 0 m
.84232 .00375 L
s
P
p
.001 w
.87264 0 m
.87264 .00375 L
s
P
p
.001 w
.90295 0 m
.90295 .00375 L
s
P
p
.001 w
.96358 0 m
.96358 .00375 L
s
P
p
.001 w
.9939 0 m
.9939 .00375 L
s
P
[(phi)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01465 m
.00625 .01465 L
s
P
[(0)] -0.0125 .01465 1 0 0 Minner Mrotshowa
p
.002 w
0 .13238 m
.00625 .13238 L
s
P
[(0.2)] -0.0125 .13238 1 0 0 Minner Mrotshowa
p
.002 w
0 .25012 m
.00625 .25012 L
s
P
[(0.4)] -0.0125 .25012 1 0 0 Minner Mrotshowa
p
.002 w
0 .36785 m
.00625 .36785 L
s
P
[(0.6)] -0.0125 .36785 1 0 0 Minner Mrotshowa
p
.002 w
0 .48558 m
.00625 .48558 L
s
P
[(0.8)] -0.0125 .48558 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03819 m
.00375 .03819 L
s
P
p
.001 w
0 .06174 m
.00375 .06174 L
s
P
p
.001 w
0 .08529 m
.00375 .08529 L
s
P
p
.001 w
0 .10883 m
.00375 .10883 L
s
P
p
.001 w
0 .15593 m
.00375 .15593 L
s
P
p
.001 w
0 .17948 m
.00375 .17948 L
s
P
p
.001 w
0 .20302 m
.00375 .20302 L
s
P
p
.001 w
0 .22657 m
.00375 .22657 L
s
P
p
.001 w
0 .27366 m
.00375 .27366 L
s
P
p
.001 w
0 .29721 m
.00375 .29721 L
s
P
p
.001 w
0 .32076 m
.00375 .32076 L
s
P
p
.001 w
0 .3443 m
.00375 .3443 L
s
P
p
.001 w
0 .3914 m
.00375 .3914 L
s
P
p
.001 w
0 .41494 m
.00375 .41494 L
s
P
p
.001 w
0 .43849 m
.00375 .43849 L
s
P
p
.001 w
0 .46204 m
.00375 .46204 L
s
P
p
.001 w
0 .50913 m
.00375 .50913 L
s
P
p
.001 w
0 .53268 m
.00375 .53268 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Pquantum \(light\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.17539 .61178 m
.17539 .61803 L
s
P
p
.002 w
.32696 .61178 m
.32696 .61803 L
s
P
p
.002 w
.47854 .61178 m
.47854 .61803 L
s
P
p
.002 w
.63011 .61178 m
.63011 .61803 L
s
P
p
.002 w
.78169 .61178 m
.78169 .61803 L
s
P
p
.002 w
.93327 .61178 m
.93327 .61803 L
s
P
p
.001 w
.05412 .61428 m
.05412 .61803 L
s
P
p
.001 w
.08444 .61428 m
.08444 .61803 L
s
P
p
.001 w
.11476 .61428 m
.11476 .61803 L
s
P
p
.001 w
.14507 .61428 m
.14507 .61803 L
s
P
p
.001 w
.2057 .61428 m
.2057 .61803 L
s
P
p
.001 w
.23602 .61428 m
.23602 .61803 L
s
P
p
.001 w
.26633 .61428 m
.26633 .61803 L
s
P
p
.001 w
.29665 .61428 m
.29665 .61803 L
s
P
p
.001 w
.35728 .61428 m
.35728 .61803 L
s
P
p
.001 w
.38759 .61428 m
.38759 .61803 L
s
P
p
.001 w
.41791 .61428 m
.41791 .61803 L
s
P
p
.001 w
.44822 .61428 m
.44822 .61803 L
s
P
p
.001 w
.50885 .61428 m
.50885 .61803 L
s
P
p
.001 w
.53917 .61428 m
.53917 .61803 L
s
P
p
.001 w
.56948 .61428 m
.56948 .61803 L
s
P
p
.001 w
.5998 .61428 m
.5998 .61803 L
s
P
p
.001 w
.66043 .61428 m
.66043 .61803 L
s
P
p
.001 w
.69074 .61428 m
.69074 .61803 L
s
P
p
.001 w
.72106 .61428 m
.72106 .61803 L
s
P
p
.001 w
.75137 .61428 m
.75137 .61803 L
s
P
p
.001 w
.81201 .61428 m
.81201 .61803 L
s
P
p
.001 w
.84232 .61428 m
.84232 .61803 L
s
P
p
.001 w
.87264 .61428 m
.87264 .61803 L
s
P
p
.001 w
.90295 .61428 m
.90295 .61803 L
s
P
p
.001 w
.96358 .61428 m
.96358 .61803 L
s
P
p
.001 w
.9939 .61428 m
.9939 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01465 m
1 .01465 L
s
P
p
.002 w
.99375 .13238 m
1 .13238 L
s
P
p
.002 w
.99375 .25012 m
1 .25012 L
s
P
p
.002 w
.99375 .36785 m
1 .36785 L
s
P
p
.002 w
.99375 .48558 m
1 .48558 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03819 m
1 .03819 L
s
P
p
.001 w
.99625 .06174 m
1 .06174 L
s
P
p
.001 w
.99625 .08529 m
1 .08529 L
s
P
p
.001 w
.99625 .10883 m
1 .10883 L
s
P
p
.001 w
.99625 .15593 m
1 .15593 L
s
P
p
.001 w
.99625 .17948 m
1 .17948 L
s
P
p
.001 w
.99625 .20302 m
1 .20302 L
s
P
p
.001 w
.99625 .22657 m
1 .22657 L
s
P
p
.001 w
.99625 .27366 m
1 .27366 L
s
P
p
.001 w
.99625 .29721 m
1 .29721 L
s
P
p
.001 w
.99625 .32076 m
1 .32076 L
s
P
p
.001 w
.99625 .3443 m
1 .3443 L
s
P
p
.001 w
.99625 .3914 m
1 .3914 L
s
P
p
.001 w
.99625 .41494 m
1 .41494 L
s
P
p
.001 w
.99625 .43849 m
1 .43849 L
s
P
p
.001 w
.99625 .46204 m
1 .46204 L
s
P
p
.001 w
.99625 .50913 m
1 .50913 L
s
P
p
.001 w
.99625 .53268 m
1 .53268 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
[(Pclassical \(dark\))] 1.0375 .30902 -1 0 90 Mrotshowa
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
.8 g
p
.02 w
.02381 .60332 m
.02505 .60331 L
.02629 .6033 L
.02753 .60328 L
.02877 .60325 L
.03001 .60321 L
.03125 .60316 L
.03373 .60303 L
.03621 .60285 L
.03869 .60262 L
.04117 .60234 L
.04365 .60199 L
.04861 .60107 L
.05357 .5998 L
.05853 .59809 L
.06349 .59582 L
.06845 .59283 L
.07341 .58892 L
.07837 .58381 L
.08333 .57713 L
.08829 .56835 L
.09325 .55676 L
.09821 .54138 L
.10317 .52083 L
.10813 .49326 L
.1131 .45623 L
.11806 .40686 L
.12302 .3425 L
.13294 .17272 L
.13542 .12826 L
.1379 .08767 L
.14038 .05396 L
.14162 .04053 L
.14286 .02975 L
.1441 .02181 L
.14534 .01679 L
.14658 .01472 L
.14782 .01551 L
.14906 .01901 L
.1503 .02501 L
.15278 .04344 L
.15526 .0684 L
.15774 .09752 L
.1627 .16034 L
.17262 .27387 L
.18254 .35586 L
.1875 .38653 L
.19246 .41189 L
.20238 .45068 L
.2123 .47838 L
Mistroke
.22222 .49883 L
.23214 .51442 L
.24206 .52662 L
.25198 .53642 L
.2619 .54445 L
.28175 .55686 L
.30159 .56607 L
.32143 .57325 L
.34127 .57908 L
.38095 .58821 L
.42063 .59524 L
.44048 .59816 L
.46032 .60064 L
.47024 .60168 L
.48016 .60251 L
.48512 .60284 L
.4876 .60298 L
.49008 .60309 L
.49256 .60319 L
.4938 .60323 L
.49504 .60326 L
.49628 .60329 L
.49752 .6033 L
.49876 .60332 L
.5 .60332 L
.50124 .60331 L
.50248 .6033 L
.50372 .60328 L
.50496 .60325 L
.5062 .60321 L
.50744 .60316 L
.50992 .60303 L
.5124 .60285 L
.51488 .60262 L
.51736 .60234 L
.51984 .60199 L
.5248 .60107 L
.52976 .5998 L
.53472 .59809 L
.53968 .59582 L
.54464 .59283 L
.5496 .58892 L
.55456 .58381 L
.55952 .57713 L
.56448 .56835 L
.56944 .55676 L
.5744 .54138 L
.57937 .52083 L
.58433 .49326 L
.58929 .45623 L
Mistroke
.59425 .40686 L
.59921 .3425 L
.60913 .17272 L
.61409 .08767 L
.61657 .05396 L
.61781 .04053 L
.61905 .02975 L
.62029 .02181 L
.62153 .01679 L
.62277 .01472 L
.62401 .01551 L
.62525 .01901 L
.62649 .02501 L
.62773 .03325 L
.62897 .04344 L
.63889 .16034 L
.64881 .27387 L
.65377 .3187 L
.65873 .35586 L
.66369 .38653 L
.66865 .41189 L
.67857 .45068 L
.68849 .47838 L
.69841 .49883 L
.70833 .51442 L
.71825 .52662 L
.72817 .53642 L
.7381 .54445 L
.75794 .55686 L
.77778 .56607 L
.79762 .57325 L
.81746 .57908 L
.85714 .58821 L
.89683 .59524 L
.91667 .59816 L
.93651 .60064 L
.94643 .60168 L
.95139 .60212 L
.95635 .60251 L
.96131 .60284 L
.96379 .60298 L
.96627 .60309 L
.96875 .60319 L
.96999 .60323 L
.97123 .60326 L
.97247 .60329 L
.97371 .6033 L
.97495 .60332 L
.97619 .60332 L
Mfstroke
P
P
p
p
.02 w
.02381 .60332 m
.02505 .60331 L
.02629 .6033 L
.02753 .60328 L
.02877 .60326 L
.03001 .60322 L
.03125 .60318 L
.03373 .60307 L
.03621 .60293 L
.03869 .60275 L
.04365 .60232 L
.05357 .60108 L
.06349 .59938 L
.08333 .5947 L
.10317 .5886 L
.14286 .57389 L
.18254 .55917 L
.20238 .55307 L
.2123 .55053 L
.22222 .5484 L
.23214 .54669 L
.2371 .54601 L
.24206 .54545 L
.24702 .54502 L
.2495 .54484 L
.25198 .5447 L
.25446 .54459 L
.2557 .54455 L
.25694 .54451 L
.25818 .54449 L
.25942 .54447 L
.26066 .54446 L
.2619 .54445 L
.26314 .54446 L
.26438 .54447 L
.26562 .54449 L
.26687 .54451 L
.26935 .54459 L
.27183 .5447 L
.27431 .54484 L
.27679 .54502 L
.28175 .54545 L
.29167 .54669 L
.30159 .5484 L
.32143 .55307 L
.34127 .55917 L
.38095 .57389 L
.42063 .5886 L
.44048 .5947 L
.4504 .59724 L
Mistroke
.46032 .59938 L
.47024 .60108 L
.48016 .60232 L
.48512 .60275 L
.4876 .60293 L
.49008 .60307 L
.49256 .60318 L
.4938 .60322 L
.49504 .60326 L
.49628 .60328 L
.49752 .6033 L
.49876 .60331 L
.5 .60332 L
.50124 .60331 L
.50248 .6033 L
.50372 .60328 L
.50496 .60326 L
.5062 .60322 L
.50744 .60318 L
.50992 .60307 L
.5124 .60293 L
.51488 .60275 L
.51984 .60232 L
.52976 .60108 L
.53968 .59938 L
.55952 .5947 L
.57937 .5886 L
.61905 .57389 L
.65873 .55917 L
.67857 .55307 L
.68849 .55053 L
.69841 .5484 L
.70833 .54669 L
.71329 .54601 L
.71825 .54545 L
.72321 .54502 L
.72569 .54484 L
.72817 .5447 L
.73065 .54459 L
.73189 .54455 L
.73313 .54451 L
.73437 .54449 L
.73562 .54447 L
.73686 .54446 L
.7381 .54445 L
.73934 .54446 L
.74058 .54447 L
.74182 .54449 L
.74306 .54451 L
.74554 .54459 L
Mistroke
.74802 .5447 L
.7505 .54484 L
.75298 .54502 L
.75794 .54545 L
.76786 .54669 L
.77778 .5484 L
.79762 .55307 L
.81746 .55917 L
.85714 .57389 L
.89683 .5886 L
.91667 .5947 L
.93651 .59938 L
.94643 .60108 L
.95139 .60176 L
.95635 .60232 L
.96131 .60275 L
.96379 .60293 L
.96627 .60307 L
.96875 .60318 L
.96999 .60322 L
.97123 .60326 L
.97247 .60328 L
.97371 .6033 L
.97495 .60331 L
.97619 .60332 L
Mfstroke
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me! (p0A=1.0, p0B=0.9)
:[font = input; preserveAspect; startGroup]
PhaseDiagram[1,0.9];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 201; pictureHeight = 201; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21429 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40476 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59524 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78571 0 0 2 0 Minner Mrotsboxa
[(1)] .97619 0 0 2 0 Minner Mrotsboxa
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .02381 1 0 0 Minner Mrotsboxa
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .97619 1 0 0 Minner Mrotsboxa
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21429 0 m
.21429 .00625 L
s
P
[(0.2)] .21429 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(0.4)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.59524 0 m
.59524 .00625 L
s
P
[(0.6)] .59524 0 0 2 0 Minner Mrotshowa
p
.002 w
.78571 0 m
.78571 .00625 L
s
P
[(0.8)] .78571 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(1)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.0619 0 m
.0619 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.1381 0 m
.1381 .00375 L
s
P
p
.001 w
.17619 0 m
.17619 .00375 L
s
P
p
.001 w
.25238 0 m
.25238 .00375 L
s
P
p
.001 w
.29048 0 m
.29048 .00375 L
s
P
p
.001 w
.32857 0 m
.32857 .00375 L
s
P
p
.001 w
.36667 0 m
.36667 .00375 L
s
P
p
.001 w
.44286 0 m
.44286 .00375 L
s
P
p
.001 w
.48095 0 m
.48095 .00375 L
s
P
p
.001 w
.51905 0 m
.51905 .00375 L
s
P
p
.001 w
.55714 0 m
.55714 .00375 L
s
P
p
.001 w
.63333 0 m
.63333 .00375 L
s
P
p
.001 w
.67143 0 m
.67143 .00375 L
s
P
p
.001 w
.70952 0 m
.70952 .00375 L
s
P
p
.001 w
.74762 0 m
.74762 .00375 L
s
P
p
.001 w
.82381 0 m
.82381 .00375 L
s
P
p
.001 w
.8619 0 m
.8619 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.9381 0 m
.9381 .00375 L
s
P
[(Pclassical)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(0)] -0.0125 .02381 1 0 0 Minner Mrotshowa
p
.002 w
0 .21429 m
.00625 .21429 L
s
P
[(0.2)] -0.0125 .21429 1 0 0 Minner Mrotshowa
p
.002 w
0 .40476 m
.00625 .40476 L
s
P
[(0.4)] -0.0125 .40476 1 0 0 Minner Mrotshowa
p
.002 w
0 .59524 m
.00625 .59524 L
s
P
[(0.6)] -0.0125 .59524 1 0 0 Minner Mrotshowa
p
.002 w
0 .78571 m
.00625 .78571 L
s
P
[(0.8)] -0.0125 .78571 1 0 0 Minner Mrotshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(1)] -0.0125 .97619 1 0 0 Minner Mrotshowa
p
.001 w
0 .0619 m
.00375 .0619 L
s
P
p
.001 w
0 .1 m
.00375 .1 L
s
P
p
.001 w
0 .1381 m
.00375 .1381 L
s
P
p
.001 w
0 .17619 m
.00375 .17619 L
s
P
p
.001 w
0 .25238 m
.00375 .25238 L
s
P
p
.001 w
0 .29048 m
.00375 .29048 L
s
P
p
.001 w
0 .32857 m
.00375 .32857 L
s
P
p
.001 w
0 .36667 m
.00375 .36667 L
s
P
p
.001 w
0 .44286 m
.00375 .44286 L
s
P
p
.001 w
0 .48095 m
.00375 .48095 L
s
P
p
.001 w
0 .51905 m
.00375 .51905 L
s
P
p
.001 w
0 .55714 m
.00375 .55714 L
s
P
p
.001 w
0 .63333 m
.00375 .63333 L
s
P
p
.001 w
0 .67143 m
.00375 .67143 L
s
P
p
.001 w
0 .70952 m
.00375 .70952 L
s
P
p
.001 w
0 .74762 m
.00375 .74762 L
s
P
p
.001 w
0 .82381 m
.00375 .82381 L
s
P
p
.001 w
0 .8619 m
.00375 .8619 L
s
P
p
.001 w
0 .9 m
.00375 .9 L
s
P
p
.001 w
0 .9381 m
.00375 .9381 L
s
P
[(Pquantum)] -0.0125 .5 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.21429 .99375 m
.21429 1 L
s
P
p
.002 w
.40476 .99375 m
.40476 1 L
s
P
p
.002 w
.59524 .99375 m
.59524 1 L
s
P
p
.002 w
.78571 .99375 m
.78571 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.0619 .99625 m
.0619 1 L
s
P
p
.001 w
.1 .99625 m
.1 1 L
s
P
p
.001 w
.1381 .99625 m
.1381 1 L
s
P
p
.001 w
.17619 .99625 m
.17619 1 L
s
P
p
.001 w
.25238 .99625 m
.25238 1 L
s
P
p
.001 w
.29048 .99625 m
.29048 1 L
s
P
p
.001 w
.32857 .99625 m
.32857 1 L
s
P
p
.001 w
.36667 .99625 m
.36667 1 L
s
P
p
.001 w
.44286 .99625 m
.44286 1 L
s
P
p
.001 w
.48095 .99625 m
.48095 1 L
s
P
p
.001 w
.51905 .99625 m
.51905 1 L
s
P
p
.001 w
.55714 .99625 m
.55714 1 L
s
P
p
.001 w
.63333 .99625 m
.63333 1 L
s
P
p
.001 w
.67143 .99625 m
.67143 1 L
s
P
p
.001 w
.70952 .99625 m
.70952 1 L
s
P
p
.001 w
.74762 .99625 m
.74762 1 L
s
P
p
.001 w
.82381 .99625 m
.82381 1 L
s
P
p
.001 w
.8619 .99625 m
.8619 1 L
s
P
p
.001 w
.9 .99625 m
.9 1 L
s
P
p
.001 w
.9381 .99625 m
.9381 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .21429 m
1 .21429 L
s
P
p
.002 w
.99375 .40476 m
1 .40476 L
s
P
p
.002 w
.99375 .59524 m
1 .59524 L
s
P
p
.002 w
.99375 .78571 m
1 .78571 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .0619 m
1 .0619 L
s
P
p
.001 w
.99625 .1 m
1 .1 L
s
P
p
.001 w
.99625 .1381 m
1 .1381 L
s
P
p
.001 w
.99625 .17619 m
1 .17619 L
s
P
p
.001 w
.99625 .25238 m
1 .25238 L
s
P
p
.001 w
.99625 .29048 m
1 .29048 L
s
P
p
.001 w
.99625 .32857 m
1 .32857 L
s
P
p
.001 w
.99625 .36667 m
1 .36667 L
s
P
p
.001 w
.99625 .44286 m
1 .44286 L
s
P
p
.001 w
.99625 .48095 m
1 .48095 L
s
P
p
.001 w
.99625 .51905 m
1 .51905 L
s
P
p
.001 w
.99625 .55714 m
1 .55714 L
s
P
p
.001 w
.99625 .63333 m
1 .63333 L
s
P
p
.001 w
.99625 .67143 m
1 .67143 L
s
P
p
.001 w
.99625 .70952 m
1 .70952 L
s
P
p
.001 w
.99625 .74762 m
1 .74762 L
s
P
p
.001 w
.99625 .82381 m
1 .82381 L
s
P
p
.001 w
.99625 .8619 m
1 .8619 L
s
P
p
.001 w
.99625 .9 m
1 .9 L
s
P
p
.001 w
.99625 .9381 m
1 .9381 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.008 w
.97619 .97619 Mdot
.97618 .97618 Mdot
.97615 .97615 Mdot
.9761 .9761 Mdot
.97604 .97603 Mdot
.97595 .97593 Mdot
.97585 .9758 Mdot
.97572 .97565 Mdot
.97558 .97547 Mdot
.97542 .97526 Mdot
.97524 .97502 Mdot
.97504 .97474 Mdot
.97483 .97443 Mdot
.97459 .97407 Mdot
.97434 .97368 Mdot
.97406 .97324 Mdot
.97377 .97274 Mdot
.97346 .9722 Mdot
.97314 .97161 Mdot
.97279 .97095 Mdot
.97243 .97023 Mdot
.97205 .96944 Mdot
.97165 .96858 Mdot
.97124 .96764 Mdot
.97081 .96661 Mdot
.97036 .9655 Mdot
.9699 .96428 Mdot
.96941 .96296 Mdot
.96892 .96153 Mdot
.9684 .95997 Mdot
.96787 .95828 Mdot
.96733 .95644 Mdot
.96677 .95445 Mdot
.96619 .95229 Mdot
.9656 .94994 Mdot
.96499 .94739 Mdot
.96437 .94463 Mdot
.96374 .94163 Mdot
.96309 .93837 Mdot
.96242 .93483 Mdot
.96175 .93098 Mdot
.96106 .9268 Mdot
.96036 .92225 Mdot
.95964 .9173 Mdot
.95891 .91191 Mdot
.95817 .90604 Mdot
.95742 .89965 Mdot
.95666 .89267 Mdot
.95588 .88506 Mdot
.9551 .87675 Mdot
.9543 .86767 Mdot
.95349 .85774 Mdot
.95268 .84689 Mdot
.95185 .83502 Mdot
.95102 .82203 Mdot
.95017 .80781 Mdot
.94932 .79225 Mdot
.94846 .77521 Mdot
.94759 .75658 Mdot
.94671 .73621 Mdot
.94583 .71396 Mdot
.94494 .68969 Mdot
.94404 .66327 Mdot
.94313 .63459 Mdot
.94222 .60354 Mdot
.94131 .57007 Mdot
.94039 .53418 Mdot
.93946 .49593 Mdot
.93854 .45549 Mdot
.9376 .41312 Mdot
.93667 .36923 Mdot
.93573 .32439 Mdot
.93478 .27931 Mdot
.93384 .23488 Mdot
.93289 .19209 Mdot
.93194 .15205 Mdot
.93099 .11588 Mdot
.93004 .08463 Mdot
.92909 .05925 Mdot
.92813 .04044 Mdot
.92718 .02862 Mdot
.92623 .02391 Mdot
.92528 .02612 Mdot
.92433 .03478 Mdot
.92338 .0492 Mdot
.92244 .06855 Mdot
.92149 .09193 Mdot
.92055 .11844 Mdot
.91962 .14721 Mdot
.91868 .17747 Mdot
.91775 .20855 Mdot
.91683 .23988 Mdot
.91591 .27099 Mdot
.91499 .30155 Mdot
.91408 .33128 Mdot
.91318 .35998 Mdot
.91228 .38754 Mdot
.91139 .41387 Mdot
.9105 .43894 Mdot
.90962 .46273 Mdot
.90875 .48527 Mdot
.90789 .50657 Mdot
.90704 .5267 Mdot
.90619 .54568 Mdot
.90536 .56359 Mdot
.90453 .58047 Mdot
.90371 .59639 Mdot
.90291 .6114 Mdot
.90211 .62556 Mdot
.90132 .63892 Mdot
.90055 .65153 Mdot
.89978 .66345 Mdot
.89903 .6747 Mdot
.89829 .68535 Mdot
.89756 .69543 Mdot
.89684 .70498 Mdot
.89614 .71403 Mdot
.89545 .72261 Mdot
.89477 .73076 Mdot
.89411 .7385 Mdot
.89346 .74586 Mdot
.89282 .75287 Mdot
.8922 .75954 Mdot
.89159 .7659 Mdot
.891 .77197 Mdot
.89042 .77776 Mdot
.88986 .78329 Mdot
.88931 .78858 Mdot
.88878 .79365 Mdot
.88827 .79849 Mdot
.88777 .80313 Mdot
.88728 .80759 Mdot
.88682 .81186 Mdot
.88637 .81596 Mdot
.88594 .8199 Mdot
.88552 .82369 Mdot
.88512 .82733 Mdot
.88474 .83084 Mdot
.88438 .83422 Mdot
.88403 .83748 Mdot
.8837 .84062 Mdot
.88339 .84365 Mdot
.8831 .84658 Mdot
.88283 .8494 Mdot
.88257 .85214 Mdot
.88234 .85478 Mdot
.88212 .85733 Mdot
.88192 .85981 Mdot
.88174 .86221 Mdot
.88157 .86453 Mdot
.88143 .86678 Mdot
.8813 .86897 Mdot
.8812 .87109 Mdot
.88111 .87314 Mdot
.88104 .87514 Mdot
.88099 .87708 Mdot
.88096 .87897 Mdot
.88095 .88081 Mdot
.88096 .88259 Mdot
.88099 .88433 Mdot
.88103 .88603 Mdot
.8811 .88768 Mdot
.88118 .88928 Mdot
.88129 .89085 Mdot
.88141 .89238 Mdot
.88155 .89387 Mdot
.88171 .89532 Mdot
.88189 .89674 Mdot
.88208 .89813 Mdot
.8823 .89948 Mdot
.88253 .90081 Mdot
.88279 .9021 Mdot
.88306 .90337 Mdot
.88335 .90461 Mdot
.88365 .90582 Mdot
.88398 .907 Mdot
.88432 .90816 Mdot
.88468 .9093 Mdot
.88506 .91041 Mdot
.88546 .91151 Mdot
.88587 .91258 Mdot
.8863 .91362 Mdot
.88675 .91465 Mdot
.88721 .91566 Mdot
.88769 .91665 Mdot
.88819 .91762 Mdot
.8887 .91858 Mdot
.88923 .91952 Mdot
.88977 .92044 Mdot
.89033 .92134 Mdot
.89091 .92223 Mdot
.8915 .9231 Mdot
.8921 .92396 Mdot
.89272 .92481 Mdot
.89336 .92564 Mdot
.894 .92645 Mdot
.89467 .92726 Mdot
.89534 .92805 Mdot
.89603 .92883 Mdot
.89673 .9296 Mdot
.89745 .93035 Mdot
.89817 .9311 Mdot
.89891 .93183 Mdot
.89966 .93256 Mdot
.90043 .93327 Mdot
.9012 .93397 Mdot
.90198 .93467 Mdot
.90278 .93535 Mdot
.90358 .93602 Mdot
.9044 .93669 Mdot
.90523 .93735 Mdot
.90606 .93799 Mdot
.9069 .93863 Mdot
.90776 .93926 Mdot
.90862 .93989 Mdot
.90949 .9405 Mdot
.91036 .94111 Mdot
.91125 .94171 Mdot
.91214 .94231 Mdot
.91303 .94289 Mdot
.91394 .94347 Mdot
.91485 .94405 Mdot
.91576 .94461 Mdot
.91668 .94517 Mdot
.9176 .94573 Mdot
.91853 .94628 Mdot
.91947 .94682 Mdot
.9204 .94735 Mdot
.92134 .94788 Mdot
.92229 .94841 Mdot
.92323 .94893 Mdot
.92418 .94944 Mdot
.92513 .94995 Mdot
.92608 .95046 Mdot
.92703 .95096 Mdot
.92798 .95145 Mdot
.92893 .95194 Mdot
.92989 .95242 Mdot
.93084 .9529 Mdot
.93179 .95338 Mdot
.93274 .95385 Mdot
.93369 .95432 Mdot
.93463 .95478 Mdot
.93558 .95524 Mdot
.93652 .95569 Mdot
.93745 .95614 Mdot
.93839 .95659 Mdot
.93932 .95703 Mdot
.94024 .95747 Mdot
.94116 .9579 Mdot
.94208 .95833 Mdot
.94299 .95875 Mdot
.94389 .95918 Mdot
.94479 .9596 Mdot
.94569 .96001 Mdot
.94657 .96042 Mdot
.94745 .96083 Mdot
.94832 .96123 Mdot
.94918 .96163 Mdot
.95004 .96203 Mdot
.95088 .96242 Mdot
.95172 .96281 Mdot
.95255 .9632 Mdot
.95336 .96358 Mdot
.95417 .96396 Mdot
.95497 .96433 Mdot
.95576 .9647 Mdot
.95653 .96507 Mdot
.9573 .96544 Mdot
.95805 .9658 Mdot
.95879 .96615 Mdot
.95952 .96651 Mdot
.96024 .96686 Mdot
.96095 .9672 Mdot
.96164 .96754 Mdot
.96232 .96788 Mdot
.96298 .96821 Mdot
.96363 .96854 Mdot
.96427 .96887 Mdot
.96489 .96919 Mdot
.9655 .96951 Mdot
.9661 .96982 Mdot
.96668 .97013 Mdot
.96724 .97043 Mdot
.96779 .97073 Mdot
.96832 .97102 Mdot
.96884 .97131 Mdot
.96934 .97159 Mdot
.96982 .97187 Mdot
.97029 .97214 Mdot
.97074 .97241 Mdot
.97117 .97267 Mdot
.97159 .97292 Mdot
.97199 .97317 Mdot
.97237 .97341 Mdot
.97274 .97364 Mdot
.97308 .97387 Mdot
.97341 .97409 Mdot
.97373 .9743 Mdot
.97402 .9745 Mdot
.97429 .97469 Mdot
.97455 .97488 Mdot
.97479 .97505 Mdot
.97501 .97521 Mdot
.97521 .97537 Mdot
.97539 .97551 Mdot
.97556 .97564 Mdot
.9757 .97576 Mdot
.97583 .97587 Mdot
.97594 .97596 Mdot
.97603 .97604 Mdot
.9761 .9761 Mdot
.97615 .97615 Mdot
.97618 .97618 Mdot
.97619 .97619 Mdot
.97618 .97618 Mdot
.97616 .97616 Mdot
.97611 .97611 Mdot
.97605 .97604 Mdot
.97597 .97594 Mdot
.97587 .97583 Mdot
.97575 .97568 Mdot
.97561 .9755 Mdot
.97545 .9753 Mdot
.97527 .97506 Mdot
.97508 .97479 Mdot
.97486 .97448 Mdot
.97463 .97413 Mdot
.97438 .97374 Mdot
.97411 .97331 Mdot
.97382 .97283 Mdot
.97351 .97229 Mdot
.97319 .9717 Mdot
.97285 .97106 Mdot
.97249 .97035 Mdot
.97211 .96957 Mdot
.97172 .96872 Mdot
.97131 .96779 Mdot
.97088 .96678 Mdot
.97043 .96568 Mdot
.96997 .96448 Mdot
.96949 .96318 Mdot
.969 .96176 Mdot
.96849 .96023 Mdot
.96796 .95856 Mdot
.96742 .95674 Mdot
.96686 .95478 Mdot
.96628 .95264 Mdot
.96569 .95033 Mdot
.96509 .94781 Mdot
.96447 .94508 Mdot
.96384 .94212 Mdot
.96319 .9389 Mdot
.96253 .93541 Mdot
.96186 .93162 Mdot
.96117 .92749 Mdot
.96047 .923 Mdot
.95975 .91812 Mdot
.95903 .9128 Mdot
.95829 .90701 Mdot
.95754 .9007 Mdot
.95678 .89382 Mdot
.95601 .88632 Mdot
.95522 .87812 Mdot
.95443 .86917 Mdot
.95362 .85938 Mdot
.95281 .84869 Mdot
.95198 .83698 Mdot
.95115 .82418 Mdot
.95031 .81016 Mdot
.94945 .79482 Mdot
.94859 .77803 Mdot
.94773 .75966 Mdot
.94685 .73958 Mdot
.94597 .71763 Mdot
.94508 .6937 Mdot
.94418 .66763 Mdot
.94328 .63931 Mdot
.94237 .60864 Mdot
.94146 .57556 Mdot
.94054 .54006 Mdot
.93961 .50218 Mdot
.93868 .46207 Mdot
.93775 .41998 Mdot
.93681 .3763 Mdot
.93587 .33157 Mdot
.93493 .28647 Mdot
.93399 .24187 Mdot
.93304 .19875 Mdot
.93209 .1582 Mdot
.93114 .12133 Mdot
.93019 .08924 Mdot
.92924 .06287 Mdot
.92828 .04297 Mdot
.92733 .03003 Mdot
.92638 .02419 Mdot
.92543 .02532 Mdot
.92448 .03299 Mdot
.92353 .04655 Mdot
.92259 .06517 Mdot
.92164 .08797 Mdot
.9207 .11404 Mdot
.91976 .14251 Mdot
.91883 .17258 Mdot
.9179 .20357 Mdot
.91697 .23489 Mdot
.91605 .26607 Mdot
.91514 .29673 Mdot
.91423 .32661 Mdot
.91332 .35549 Mdot
.91242 .38323 Mdot
.91153 .40976 Mdot
.91064 .43503 Mdot
.90976 .45903 Mdot
.90889 .48176 Mdot
.90803 .50326 Mdot
.90717 .52357 Mdot
.90633 .54273 Mdot
.90549 .56081 Mdot
.90466 .57785 Mdot
.90384 .59392 Mdot
.90303 .60907 Mdot
.90224 .62336 Mdot
.90145 .63685 Mdot
.90067 .64957 Mdot
.8999 .66159 Mdot
.89915 .67295 Mdot
.89841 .6837 Mdot
.89768 .69386 Mdot
.89696 .70349 Mdot
.89625 .71262 Mdot
.89556 .72127 Mdot
.89488 .72949 Mdot
.89421 .73729 Mdot
.89356 .74472 Mdot
.89292 .75178 Mdot
.8923 .7585 Mdot
.89169 .76491 Mdot
.89109 .77102 Mdot
.89051 .77686 Mdot
.88995 .78243 Mdot
.8894 .78776 Mdot
.88887 .79285 Mdot
.88835 .79773 Mdot
.88785 .80241 Mdot
.88736 .80689 Mdot
.88689 .81119 Mdot
.88644 .81532 Mdot
.886 .81928 Mdot
.88559 .8231 Mdot
.88518 .82676 Mdot
.8848 .83029 Mdot
.88443 .83369 Mdot
.88409 .83697 Mdot
.88375 .84013 Mdot
.88344 .84317 Mdot
.88315 .84612 Mdot
.88287 .84896 Mdot
.88261 .85171 Mdot
.88237 .85436 Mdot
.88215 .85693 Mdot
.88195 .85942 Mdot
.88176 .86183 Mdot
.8816 .86416 Mdot
.88145 .86643 Mdot
.88132 .86862 Mdot
.88121 .87075 Mdot
.88112 .87282 Mdot
.88105 .87483 Mdot
.881 .87678 Mdot
.88097 .87867 Mdot
.88095 .88052 Mdot
.88096 .88231 Mdot
.88098 .88406 Mdot
.88102 .88576 Mdot
.88109 .88742 Mdot
.88117 .88903 Mdot
.88127 .8906 Mdot
.88139 .89214 Mdot
.88152 .89363 Mdot
.88168 .89509 Mdot
.88186 .89652 Mdot
.88205 .89791 Mdot
.88226 .89927 Mdot
.88249 .9006 Mdot
.88274 .9019 Mdot
.88301 .90317 Mdot
.8833 .90441 Mdot
.8836 .90563 Mdot
.88393 .90682 Mdot
.88427 .90798 Mdot
.88462 .90912 Mdot
.885 .91024 Mdot
.88539 .91133 Mdot
.8858 .91241 Mdot
.88623 .91346 Mdot
.88667 .91449 Mdot
.88713 .9155 Mdot
.88761 .9165 Mdot
.88811 .91747 Mdot
.88862 .91843 Mdot
.88914 .91937 Mdot
.88968 .92029 Mdot
.89024 .9212 Mdot
.89081 .92209 Mdot
.8914 .92296 Mdot
.892 .92383 Mdot
.89262 .92467 Mdot
.89325 .92551 Mdot
.8939 .92633 Mdot
.89456 .92713 Mdot
.89523 .92793 Mdot
.89592 .92871 Mdot
.89662 .92948 Mdot
.89733 .93023 Mdot
.89806 .93098 Mdot
.89879 .93172 Mdot
.89954 .93244 Mdot
.9003 .93316 Mdot
.90107 .93386 Mdot
.90186 .93456 Mdot
.90265 .93524 Mdot
.90346 .93592 Mdot
.90427 .93658 Mdot
.90509 .93724 Mdot
.90593 .93789 Mdot
.90677 .93853 Mdot
.90762 .93916 Mdot
.90848 .93979 Mdot
.90935 .94041 Mdot
.91022 .94102 Mdot
.9111 .94162 Mdot
.91199 .94221 Mdot
.91289 .9428 Mdot
.91379 .94338 Mdot
.9147 .94396 Mdot
.91561 .94452 Mdot
.91653 .94508 Mdot
.91746 .94564 Mdot
.91839 .94619 Mdot
.91932 .94673 Mdot
.92025 .94727 Mdot
.92119 .9478 Mdot
.92214 .94833 Mdot
.92308 .94885 Mdot
.92403 .94936 Mdot
.92498 .94987 Mdot
.92593 .95038 Mdot
.92688 .95088 Mdot
.92783 .95137 Mdot
.92878 .95186 Mdot
.92973 .95235 Mdot
.93069 .95283 Mdot
.93164 .9533 Mdot
.93259 .95378 Mdot
.93354 .95424 Mdot
.93448 .95471 Mdot
.93542 .95516 Mdot
.93637 .95562 Mdot
.9373 .95607 Mdot
.93824 .95652 Mdot
.93917 .95696 Mdot
.9401 .9574 Mdot
.94102 .95783 Mdot
.94193 .95826 Mdot
.94285 .95869 Mdot
.94375 .95911 Mdot
.94465 .95953 Mdot
.94554 .95994 Mdot
.94643 .96036 Mdot
.94731 .96076 Mdot
.94818 .96117 Mdot
.94904 .96157 Mdot
.9499 .96197 Mdot
.95075 .96236 Mdot
.95159 .96275 Mdot
.95242 .96314 Mdot
.95323 .96352 Mdot
.95404 .9639 Mdot
.95484 .96427 Mdot
.95563 .96465 Mdot
.95641 .96501 Mdot
.95718 .96538 Mdot
.95793 .96574 Mdot
.95868 .9661 Mdot
.95941 .96645 Mdot
.96013 .9668 Mdot
.96084 .96715 Mdot
.96153 .96749 Mdot
.96221 .96783 Mdot
.96288 .96816 Mdot
.96353 .96849 Mdot
.96417 .96882 Mdot
.9648 .96914 Mdot
.96541 .96946 Mdot
.966 .96977 Mdot
.96658 .97008 Mdot
.96715 .97038 Mdot
.9677 .97068 Mdot
.96824 .97097 Mdot
.96875 .97126 Mdot
.96926 .97155 Mdot
.96974 .97183 Mdot
.97021 .9721 Mdot
.97067 .97236 Mdot
.97111 .97263 Mdot
.97152 .97288 Mdot
.97193 .97313 Mdot
.97231 .97337 Mdot
.97268 .9736 Mdot
.97303 .97383 Mdot
.97336 .97405 Mdot
.97368 .97426 Mdot
.97397 .97447 Mdot
.97425 .97466 Mdot
.97451 .97485 Mdot
.97475 .97502 Mdot
.97498 .97519 Mdot
.97518 .97534 Mdot
.97537 .97549 Mdot
.97553 .97562 Mdot
.97568 .97574 Mdot
.97581 .97585 Mdot
.97592 .97595 Mdot
.97601 .97603 Mdot
.97609 .97609 Mdot
.97614 .97614 Mdot
.97617 .97617 Mdot
.97619 .97619 Mdot
P
p
[ .01 .01 ] 0 setdash
p
.004 w
.02381 .02381 m
.06349 .06349 L
.10317 .10317 L
.14286 .14286 L
.18254 .18254 L
.22222 .22222 L
.2619 .2619 L
.30159 .30159 L
.34127 .34127 L
.38095 .38095 L
.42063 .42063 L
.46032 .46032 L
.5 .5 L
.53968 .53968 L
.57937 .57937 L
.61905 .61905 L
.65873 .65873 L
.69841 .69841 L
.7381 .7381 L
.77778 .77778 L
.81746 .81746 L
.85714 .85714 L
.89683 .89683 L
.93651 .93651 L
.97619 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; endGroup; endGroup; endGroup]
PhaseDiagram[0.75, 0.25]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Code for interference analysis in here ...
:[font = subsubsection; inactive; preserveAspect; startGroup]
Converting between p and phi
:[font = input; initialization; preserveAspect; endGroup]
*)
ProbabilityToAngle[p_]:= ArcCos[Sqrt[p]]
AngleToProbability[phi_]:= Cos[phi]^2
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Pclassical
:[font = input; initialization; preserveAspect; endGroup]
*)
Pclassical[phi_, p0A_, p0B_]:=
	Expand[Cos[phi]^2 p0A + Sin[phi]^2 p0B, Trig->True]
	
Pclassical::usage =
	"Pclassical[phi, p0A, p0B] gives the probability of a classical \
	computer picking a 0 using either Method A or Method B.";
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Pquantum
:[font = input; initialization; preserveAspect; endGroup]
*)
Pquantum[phi_, p0A_, p0B_]:=
	Module[{a0,b0,a1,b1,norm},
		a0 = Sqrt[p0A];  a1 = Sqrt[1-p0A];
		b0 = -Sqrt[p0B]; b1 = Sqrt[1-p0B];
		norm = Sqrt[Abs[(Cos[phi] a0 + Sin[phi] b0)]^2 +
		            Abs[(Cos[phi] a1 + Sin[phi] b1)]^2];
		(Abs[(Cos[phi] a0 + Sin[phi] b0)/norm]^2) // SimplifyAbs // Chop
	]

Pquantum::usage =
	"Pquantum[phi, p0A, p0B] gives the probability of a quantum \
	computer picking a 0 using both Method A or Method B in quantum \
	parallel. Note that both computational pathways are pursued. The \
	final answer is arrived as as the outcome from the interference \
	between these computational pathways.";
	
(* A valid simplification for Abs[x]^2 iff x is real,
   In our case, x is guaranteed to be real.
*)
SimplifyAbs[expr_]:=
	ExpandAll[expr //. Abs[x_]^2 :> x^2, Trig->True]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Comparison of Pclassical and Pquantum versus phi
:[font = input; initialization; preserveAspect; endGroup]
*)
ComparisonPlot[p0A_, p0B_]:=
	Plot[{Pquantum[phi, p0A, p0B],
	      Pclassical[phi, p0A, p0B]}, {phi, 0, N[2 Pi]},
	     PlotStyle->{{Thickness[0.02], GrayLevel[0.8]}, 
	                 {Thickness[0.02]}},
	     Frame->True,
	     FrameLabel->{"phi", "Pquantum (light)", "", "Pclassical (dark)"},
	     GridLines->Automatic,
	     PlotRange->All
	]/;Which[Not[NumberQ[N[p0A]] && NumberQ[N[p0B]]],
	         	(Message[ComparisonPlot::nonnumeric]; Abort[]),
	         (N[p0A]<0 || N[p0A]>1) || (N[p0B]<0 || N[p0B]>1),
             	(Message[ComparisonPlot::nonprobability]; Abort[]),
             True, 
            	True
            ]
	
ComparisonPlot::usage =
	"ComparisonPlot[p0A, p0B] creates a plot that allows you to compare \
	Pclassical (dark) and Pquantum (light) as the angle phi changes \
	from 0 to 2 Pi.";
	
ComparisonPlot::nonprobability =
	"Sorry p0A and p0B must both be real numbers in the range \
	0 <= p0A, p0B <= 1 as they are supposed to be probabilities.";
	
ComparisonPlot::nonnumeric =
	"Sorry p0A and p0B must both be real numbers in the range \
	0 <= p0A, p0B <= 1. Your inputs are not both numbers.";
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Region where Quantum Probability exceeds Classical Probability
:[font = input; initialization; preserveAspect; endGroup; endGroup; endGroup]
*)
PhaseDiagram[p0A_, p0B_]:=
	Module[{data, plot1, plot2},
		data = Table[{Pclassical[N[phi], N[p0A], N[p0B]],
                      Pquantum[N[phi], N[p0A], N[p0B]]}, {phi, 0, 2 Pi, 0.01}];
        plot1 = ListPlot[data, 
                         Frame->True,
                         FrameLabel->{"Pclassical", "Pquantum"},
                         Axes->False,
                         AspectRatio->Automatic,
                         PlotRange->{All,All},
                         DisplayFunction->Identity];
        plot2 = Plot[x,{x,0,1},
                     PlotStyle->Dashing[{0.01, 0.01}],
                     DisplayFunction->Identity];
        Show[plot1, plot2, DisplayFunction:>$DisplayFunction]
    ]/;Which[Not[NumberQ[N[p0A]] && NumberQ[N[p0B]]],
	         	(Message[PhaseDiagram::nonnumeric]; Abort[]),
	         (N[p0A]<0 || N[p0A]>1) || (N[p0B]<0 || N[p0B]>1),
             	(Message[PhaseDiagram::nonprobability]; Abort[]),
             True, 
            	True
            ]
    
PhaseDiagram::usage =
	"PhaseDiagram[p0A, p0B] displays corresponding pairs of values \
	for Pclassical and Pquantum. The line at 45 degrees indicates where \
	both probabilities are equal. In the region above this line \
	Pquantum > Pclassical and in the region below the 45 degree line \
	Pquantum < Pclassical.";

PhaseDiagram::nonprobability =
	"Sorry p0A and p0B must both be real numbers in the range \
	0 <= p0A, p0B <= 1 as they are supposed to be probabilities.";

PhaseDiagram::nonnumeric =
	"Sorry p0A and p0B must both be real numbers in the range \
	0 <= p0A, p0B <= 1. Your inputs are not both numbers.";	
(*
^*)
